/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.state.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.ConditionalOutputStream;
import io.pravega.client.segment.impl.EndOfSegmentException;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentAttribute;
import io.pravega.client.segment.impl.SegmentInfo;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentOutputStream;
import io.pravega.client.segment.impl.SegmentOutputStreamFactory;
import io.pravega.client.segment.impl.SegmentSealedException;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.client.state.Revision;
import io.pravega.client.state.RevisionedStreamClient;
import io.pravega.client.state.impl.CorruptedStateException;
import io.pravega.client.state.impl.RevisionImpl;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.TruncatedDataException;
import io.pravega.client.stream.impl.PendingEvent;
import io.pravega.common.concurrent.Futures;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevisionedStreamClientImpl<T>
implements RevisionedStreamClient<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RevisionedStreamClientImpl.class);
    private static final long READ_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(30L);
    @VisibleForTesting
    private final long readTimeout;
    private final Segment segment;
    @GuardedBy(value="lock")
    private final EventSegmentReader in;
    @GuardedBy(value="lock")
    private final SegmentOutputStream out;
    @GuardedBy(value="lock")
    private final ConditionalOutputStream conditional;
    @GuardedBy(value="lock")
    @VisibleForTesting
    private final SegmentMetadataClient meta;
    private final Serializer<T> serializer;
    private final Object lock = new Object();

    public RevisionedStreamClientImpl(Segment segment, EventSegmentReader in, SegmentOutputStreamFactory outFactory, ConditionalOutputStream conditional, SegmentMetadataClient meta, Serializer<T> serializer, EventWriterConfig config, DelegationTokenProvider tokenProvider) {
        this.readTimeout = READ_TIMEOUT_MS;
        this.segment = segment;
        this.in = in;
        this.conditional = conditional;
        this.meta = meta;
        this.serializer = serializer;
        this.out = outFactory.createOutputStreamForSegment(segment, s2 -> this.handleSegmentSealed(), config, tokenProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Revision writeConditionally(Revision latestRevision, T value) {
        boolean wasWritten;
        long offset = latestRevision.asImpl().getOffsetInSegment();
        ByteBuffer serialized = this.serializer.serialize(value);
        int size = serialized.remaining();
        Object object = this.lock;
        synchronized (object) {
            try {
                wasWritten = this.conditional.write(serialized, offset);
            }
            catch (SegmentSealedException e) {
                throw new CorruptedStateException("Unexpected end of segment ", e);
            }
        }
        if (wasWritten) {
            long newOffset = RevisionedStreamClientImpl.getNewOffset(offset, size);
            log.debug("Wrote from {} to {}", (Object)offset, (Object)newOffset);
            return new RevisionImpl(this.segment, newOffset, 0);
        }
        log.debug("Conditional write failed at offset {}", (Object)offset);
        return null;
    }

    private static final long getNewOffset(long initial, int size) {
        return initial + (long)size + 8L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnconditionally(T value) {
        CompletableFuture<Void> ack = new CompletableFuture<Void>();
        ByteBuffer serialized = this.serializer.serialize(value);
        try {
            PendingEvent event = PendingEvent.withHeader(null, serialized, ack);
            log.trace("Unconditionally writing: {} to segment {}", value, (Object)this.segment);
            Object object = this.lock;
            synchronized (object) {
                this.out.write(event);
                this.out.flush();
            }
        }
        catch (SegmentSealedException e) {
            throw new CorruptedStateException("Unexpected end of segment ", e);
        }
        Futures.getAndHandleExceptions(ack, RuntimeException::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Map.Entry<Revision, T>> readFrom(Revision start) {
        log.trace("Read segment {} from revision {}", (Object)this.segment, (Object)start);
        Object object = this.lock;
        synchronized (object) {
            long startOffset = start.asImpl().getOffsetInSegment();
            SegmentInfo segmentInfo = this.meta.getSegmentInfo();
            long endOffset = segmentInfo.getWriteOffset();
            if (startOffset < segmentInfo.getStartingOffset()) {
                throw new TruncatedDataException(String.format("Data at the supplied revision {%s} has been truncated. The current segment info is {%s}", start, segmentInfo));
            }
            log.debug("Creating iterator from {} until {} for segment {} ", new Object[]{startOffset, endOffset, this.segment});
            return new StreamIterator(startOffset, endOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Revision fetchLatestRevision() {
        Object object = this.lock;
        synchronized (object) {
            long streamLength = this.meta.fetchCurrentSegmentLength();
            return new RevisionImpl(this.segment, streamLength, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Revision getMark() {
        log.trace("Fetching mark for segment {}", (Object)this.segment);
        Object object = this.lock;
        synchronized (object) {
            long value = this.meta.fetchProperty(SegmentAttribute.RevisionStreamClientMark);
            return value == Long.MIN_VALUE ? null : new RevisionImpl(this.segment, value, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSetMark(Revision expected, Revision newLocation) {
        long expectedValue = expected == null ? Long.MIN_VALUE : expected.asImpl().getOffsetInSegment();
        long newValue = newLocation == null ? Long.MIN_VALUE : newLocation.asImpl().getOffsetInSegment();
        Object object = this.lock;
        synchronized (object) {
            return this.meta.compareAndSetAttribute(SegmentAttribute.RevisionStreamClientMark, expectedValue, newValue);
        }
    }

    @Override
    public Revision fetchOldestRevision() {
        long startingOffset = this.meta.getSegmentInfo().getStartingOffset();
        return new RevisionImpl(this.segment, startingOffset, 0);
    }

    @Override
    public void truncateToRevision(Revision newStart) {
        this.meta.truncateSegment(newStart.asImpl().getOffsetInSegment());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.out.close();
            }
            catch (SegmentSealedException e) {
                log.warn("Error closing segment writer {}", (Object)this.out);
            }
            this.conditional.close();
            this.meta.close();
            this.in.close();
        }
    }

    @VisibleForTesting
    void handleSegmentSealed() {
        log.debug("Complete all unacked events with SegmentSealedException for segment {}", (Object)this.segment);
        List<PendingEvent> r = this.out.getUnackedEventsOnSeal();
        r.stream().filter(pendingEvent -> pendingEvent.getAckFuture() != null).forEach(pendingEvent -> pendingEvent.getAckFuture().completeExceptionally(new SegmentSealedException(this.segment.toString())));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getReadTimeout() {
        return this.readTimeout;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentMetadataClient getMeta() {
        return this.meta;
    }

    private class StreamIterator
    implements Iterator<Map.Entry<Revision, T>> {
        private final AtomicLong offset;
        private final long endOffset;

        StreamIterator(long startingOffset, long endOffset) {
            this.offset = new AtomicLong(startingOffset);
            this.endOffset = endOffset;
        }

        @Override
        public boolean hasNext() {
            return this.offset.get() < this.endOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<Revision, T> next() {
            RevisionImpl revision;
            ByteBuffer data;
            Object object = RevisionedStreamClientImpl.this.lock;
            synchronized (object) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                log.trace("Iterator reading entry at {}", (Object)this.offset.get());
                RevisionedStreamClientImpl.this.in.setOffset(this.offset.get());
                try {
                    do {
                        if ((data = RevisionedStreamClientImpl.this.in.read(RevisionedStreamClientImpl.this.getReadTimeout())) != null) continue;
                        log.warn("Timeout while attempting to read offset:{} on segment:{} where the endOffset is {}", new Object[]{this.offset, RevisionedStreamClientImpl.this.segment, this.endOffset});
                        RevisionedStreamClientImpl.this.in.setOffset(this.offset.get(), true);
                    } while (data == null);
                }
                catch (EndOfSegmentException e) {
                    throw new IllegalStateException("SegmentInputStream: " + RevisionedStreamClientImpl.this.in + " shrunk from its original length: " + this.endOffset);
                }
                catch (SegmentTruncatedException e) {
                    throw new TruncatedDataException(String.format("Offset at which truncation observed is {%s}", RevisionedStreamClientImpl.this.in.getOffset()), e);
                }
                this.offset.set(RevisionedStreamClientImpl.this.in.getOffset());
                revision = new RevisionImpl(RevisionedStreamClientImpl.this.segment, this.offset.get(), 0);
            }
            return new AbstractMap.SimpleImmutableEntry(revision, RevisionedStreamClientImpl.this.serializer.deserialize(data));
        }
    }
}

