/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import io.pravega.client.stream.impl.StreamImpl;
import io.pravega.common.Exceptions;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shared.NameUtils;

public interface Stream {
    public String getScope();

    public String getStreamName();

    public String getScopedName();

    public static Stream of(String scope, String streamName) {
        NameUtils.validateScopeName(scope);
        NameUtils.validateStreamName(streamName);
        return new StreamImpl(scope, streamName);
    }

    public static Stream of(String scopedName) {
        Exceptions.checkNotNullOrEmpty(scopedName, "scopedName");
        String[] split = scopedName.split("/", 2);
        Preconditions.checkArgument(split.length == 2, "Ensure a fully scoped name of a stream is passed e.g: scopeName/streamName");
        NameUtils.validateScopeName(split[0]);
        NameUtils.validateStreamName(split[1]);
        return new StreamImpl(split[0], split[1]);
    }
}

