/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.EventPointer;
import io.pravega.client.stream.impl.EventPointerInternal;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import lombok.Generated;

public class EventPointerImpl
extends EventPointerInternal {
    private static final EventPointerSerializer SERIALIZER = new EventPointerSerializer();
    private final Segment segment;
    private final long eventStartOffset;
    private final int eventLength;

    EventPointerImpl(Segment segment, long eventStartOffset, int eventLength) {
        this.segment = segment;
        this.eventStartOffset = eventStartOffset;
        this.eventLength = eventLength;
    }

    @Override
    Segment getSegment() {
        return this.segment;
    }

    @Override
    long getEventStartOffset() {
        return this.eventStartOffset;
    }

    @Override
    int getEventLength() {
        return this.eventLength;
    }

    @Override
    public EventPointerInternal asImpl() {
        return this;
    }

    public static EventPointer fromString(String eventPointer) {
        int i = eventPointer.lastIndexOf(":");
        Preconditions.checkArgument(i > 0, "Invalid event pointer: %s", (Object)eventPointer);
        String[] offset = eventPointer.substring(i + 1).split("-");
        Preconditions.checkArgument(offset.length == 2, "Invalid event pointer: %s", (Object)eventPointer);
        return new EventPointerImpl(Segment.fromScopedName(eventPointer.substring(0, i)), Long.parseLong(offset[0]), Integer.parseInt(offset[1]));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.segment.getScopedName());
        sb.append(':');
        sb.append(this.eventStartOffset);
        sb.append('-');
        sb.append(this.eventLength);
        return sb.toString();
    }

    @Override
    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static EventPointerInternal fromBytes(ByteBuffer data) {
        return (EventPointerInternal)SERIALIZER.deserialize(new ByteArraySegment(data));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static EventPointerBuilder builder() {
        return new EventPointerBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventPointerImpl)) {
            return false;
        }
        EventPointerImpl other = (EventPointerImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Segment this$segment = this.getSegment();
        Segment other$segment = other.getSegment();
        if (this$segment == null ? other$segment != null : !((Object)this$segment).equals(other$segment)) {
            return false;
        }
        if (this.getEventStartOffset() != other.getEventStartOffset()) {
            return false;
        }
        return this.getEventLength() == other.getEventLength();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventPointerImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Segment $segment = this.getSegment();
        result = result * 59 + ($segment == null ? 43 : ((Object)$segment).hashCode());
        long $eventStartOffset = this.getEventStartOffset();
        result = result * 59 + (int)($eventStartOffset >>> 32 ^ $eventStartOffset);
        result = result * 59 + this.getEventLength();
        return result;
    }

    private static class EventPointerSerializer
    extends VersionedSerializer.WithBuilder<EventPointerImpl, EventPointerBuilder> {
        private EventPointerSerializer() {
        }

        @Override
        protected EventPointerBuilder newBuilder() {
            return EventPointerImpl.builder();
        }

        @Override
        protected byte getWriteVersion() {
            return 0;
        }

        @Override
        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, EventPointerBuilder builder) throws IOException {
            builder.segment(Segment.fromScopedName(revisionDataInput.readUTF()));
            builder.eventStartOffset(revisionDataInput.readCompactLong());
            builder.eventLength(revisionDataInput.readCompactInt());
        }

        private void write00(EventPointerImpl pointer, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(pointer.getSegment().getScopedName());
            revisionDataOutput.writeCompactLong(pointer.eventStartOffset);
            revisionDataOutput.writeCompactInt(pointer.getEventLength());
        }
    }

    private static class EventPointerBuilder
    implements ObjectBuilder<EventPointerImpl> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Segment segment;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long eventStartOffset;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int eventLength;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        EventPointerBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventPointerBuilder segment(Segment segment) {
            this.segment = segment;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventPointerBuilder eventStartOffset(long eventStartOffset) {
            this.eventStartOffset = eventStartOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventPointerBuilder eventLength(int eventLength) {
            this.eventLength = eventLength;
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventPointerImpl build() {
            return new EventPointerImpl(this.segment, this.eventStartOffset, this.eventLength);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "EventPointerImpl.EventPointerBuilder(segment=" + this.segment + ", eventStartOffset=" + this.eventStartOffset + ", eventLength=" + this.eventLength + ")";
        }
    }
}

