/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import io.pravega.shaded.io.netty.buffer.Unpooled;
import io.pravega.shared.protocol.netty.WireCommands;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;

public class PendingEvent {
    public static final int MAX_WRITE_SIZE = 0x800008;
    private final String routingKey;
    private final ByteBuf data;
    private final int eventCount;
    private final CompletableFuture<Void> ackFuture;

    private PendingEvent(String routingKey, ByteBuf data, int eventCount, CompletableFuture<Void> ackFuture) {
        Preconditions.checkNotNull(data);
        this.routingKey = routingKey;
        this.data = data;
        this.ackFuture = ackFuture;
        this.eventCount = eventCount;
    }

    public static PendingEvent withHeader(String routingKey, ByteBuffer data, CompletableFuture<Void> ackFuture) {
        ByteBuf eventBuf = PendingEvent.getByteBuf(data);
        return new PendingEvent(routingKey, eventBuf, 1, ackFuture);
    }

    public static PendingEvent withHeader(@NonNull String routingKey, @NonNull List<ByteBuffer> batch, @NonNull CompletableFuture<Void> ackFuture) {
        if (routingKey == null) {
            throw new NullPointerException("routingKey is marked non-null but is null");
        }
        if (batch == null) {
            throw new NullPointerException("batch is marked non-null but is null");
        }
        if (ackFuture == null) {
            throw new NullPointerException("ackFuture is marked non-null but is null");
        }
        Preconditions.checkArgument(!batch.isEmpty(), "Batch cannot be empty");
        ByteBuf[] buffers = new ByteBuf[batch.size()];
        for (int i = 0; i < batch.size(); ++i) {
            buffers[i] = PendingEvent.getByteBuf(batch.get(i));
        }
        ByteBuf batchBuff = Unpooled.wrappedUnmodifiableBuffer(buffers);
        Preconditions.checkArgument(batchBuff.readableBytes() <= 0x1000010, "Batch size too large: %s", batchBuff.readableBytes());
        return new PendingEvent(routingKey, batchBuff, batch.size(), ackFuture);
    }

    public static PendingEvent withoutHeader(String routingKey, ByteBuffer data, CompletableFuture<Void> ackFuture) {
        ByteBuf dataBuf = Unpooled.wrappedBuffer(data);
        Preconditions.checkArgument(dataBuf.readableBytes() <= 0x800008, "Write size too large: %s", dataBuf.readableBytes());
        return new PendingEvent(routingKey, dataBuf, 1, ackFuture);
    }

    private static ByteBuf getByteBuf(ByteBuffer data) {
        ByteBuf eventBuf = new WireCommands.Event(Unpooled.wrappedBuffer(data)).getAsByteBuf();
        Preconditions.checkArgument(eventBuf.readableBytes() <= 0x800008, "Write size too large: %s", eventBuf.readableBytes());
        return eventBuf;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRoutingKey() {
        return this.routingKey;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuf getData() {
        return this.data;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEventCount() {
        return this.eventCount;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CompletableFuture<Void> getAckFuture() {
        return this.ackFuture;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PendingEvent)) {
            return false;
        }
        PendingEvent other = (PendingEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        ByteBuf this$data = this.getData();
        ByteBuf other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        if (this.getEventCount() != other.getEventCount()) {
            return false;
        }
        CompletableFuture<Void> this$ackFuture = this.getAckFuture();
        CompletableFuture<Void> other$ackFuture = other.getAckFuture();
        return !(this$ackFuture == null ? other$ackFuture != null : !this$ackFuture.equals(other$ackFuture));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PendingEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        ByteBuf $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        result = result * 59 + this.getEventCount();
        CompletableFuture<Void> $ackFuture = this.getAckFuture();
        result = result * 59 + ($ackFuture == null ? 43 : $ackFuture.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "PendingEvent(routingKey=" + this.getRoutingKey() + ", data=" + this.getData() + ", eventCount=" + this.getEventCount() + ", ackFuture=" + this.getAckFuture() + ")";
    }
}

