/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.Transaction;
import io.pravega.common.Exceptions;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.io.grpc.Status;
import io.pravega.shaded.io.grpc.StatusRuntimeException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pinger
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Pinger.class);
    private final Stream stream;
    private final Controller controller;
    private final long txnLeaseMillis;
    private final long pingIntervalMillis;
    private final ScheduledExecutorService executor;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Set<UUID> txnList = new HashSet<UUID>();
    @VisibleForTesting
    @GuardedBy(value="lock")
    private final Set<UUID> completedTxns = new HashSet<UUID>();
    private final AtomicBoolean isStarted = new AtomicBoolean();
    private final AtomicReference<ScheduledFuture<?>> scheduledFuture = new AtomicReference();

    Pinger(long txnLeaseMillis, Stream stream, Controller controller, ScheduledExecutorService executor) {
        this.txnLeaseMillis = txnLeaseMillis;
        this.pingIntervalMillis = this.getPingInterval();
        this.stream = stream;
        this.controller = controller;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startPing(UUID txnID) {
        Object object = this.lock;
        synchronized (object) {
            this.txnList.add(txnID);
        }
        this.startPeriodicPingTxn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPing(UUID txnID) {
        Object object = this.lock;
        synchronized (object) {
            this.txnList.remove(txnID);
        }
    }

    private long getPingInterval() {
        double targetNumPings = Math.max(1.0, Math.sqrt((double)this.txnLeaseMillis / 1000.0));
        return Math.round((double)this.txnLeaseMillis / targetNumPings);
    }

    private void startPeriodicPingTxn() {
        if (!this.isStarted.getAndSet(true)) {
            log.info("Starting Pinger at an interval of {}ms ", (Object)this.pingIntervalMillis);
            this.scheduledFuture.set(this.executor.scheduleAtFixedRate(this::pingTransactions, 10L, this.pingIntervalMillis, TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingTransactions() {
        log.info("Start sending transaction pings.");
        Object object = this.lock;
        synchronized (object) {
            this.txnList.removeAll(this.completedTxns);
            this.completedTxns.clear();
            this.txnList.forEach(uuid -> {
                try {
                    log.debug("Sending ping request for txn ID: {} with lease: {}", uuid, (Object)this.txnLeaseMillis);
                    this.controller.pingTransaction(this.stream, (UUID)uuid, this.txnLeaseMillis).whenComplete((status, e) -> {
                        if (e != null) {
                            Throwable unwrap = Exceptions.unwrap(e);
                            if (unwrap instanceof StatusRuntimeException && ((StatusRuntimeException)unwrap).getStatus().equals(Status.NOT_FOUND)) {
                                log.info("Ping Transaction for txn ID:{} did not find the transaction", uuid);
                                this.completedTxns.add((UUID)uuid);
                            }
                            log.warn("Ping Transaction for txn ID:{} failed", uuid, (Object)Exceptions.unwrap(e));
                        } else if (Transaction.PingStatus.ABORTED.equals(status) || Transaction.PingStatus.COMMITTED.equals(status)) {
                            this.completedTxns.add((UUID)uuid);
                        }
                    });
                }
                catch (Exception e2) {
                    log.warn("Encountered exception when attempting to ping transactions", (Throwable)e2);
                }
            });
        }
        log.trace("Completed sending transaction pings.");
    }

    @Override
    public void close() {
        log.info("Closing Pinger periodic task");
        ScheduledFuture future = this.scheduledFuture.getAndSet(null);
        if (future != null) {
            future.cancel(false);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    Set<UUID> getCompletedTxns() {
        return this.completedTxns;
    }
}

