/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables;

import io.pravega.client.tables.IteratorItem;
import io.pravega.client.tables.IteratorState;
import io.pravega.client.tables.KeyValueTableMap;
import io.pravega.client.tables.TableEntry;
import io.pravega.client.tables.TableKey;
import io.pravega.client.tables.Version;
import io.pravega.common.util.AsyncIterator;
import io.pravega.shaded.com.google.common.annotations.Beta;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import lombok.NonNull;

@Beta
public interface KeyValueTable<KeyT, ValueT>
extends AutoCloseable {
    public static final int MAXIMUM_SERIALIZED_KEY_LENGTH = 4096;
    public static final int MAXIMUM_SERIALIZED_VALUE_LENGTH = 1040384;

    public CompletableFuture<Version> put(@Nullable String var1, @NonNull KeyT var2, @NonNull ValueT var3);

    public CompletableFuture<Version> putIfAbsent(@Nullable String var1, @NonNull KeyT var2, @NonNull ValueT var3);

    public CompletableFuture<List<Version>> putAll(@NonNull String var1, @NonNull Iterable<Map.Entry<KeyT, ValueT>> var2);

    public CompletableFuture<Version> replace(@Nullable String var1, @NonNull KeyT var2, @NonNull ValueT var3, @NonNull Version var4);

    public CompletableFuture<List<Version>> replaceAll(@NonNull String var1, @NonNull Iterable<TableEntry<KeyT, ValueT>> var2);

    public CompletableFuture<Void> remove(@Nullable String var1, @NonNull KeyT var2);

    public CompletableFuture<Void> remove(@Nullable String var1, @NonNull KeyT var2, @NonNull Version var3);

    public CompletableFuture<Void> removeAll(@Nullable String var1, @NonNull Iterable<TableKey<KeyT>> var2);

    public CompletableFuture<TableEntry<KeyT, ValueT>> get(@Nullable String var1, @NonNull KeyT var2);

    public CompletableFuture<List<TableEntry<KeyT, ValueT>>> getAll(@Nullable String var1, @NonNull Iterable<KeyT> var2);

    public AsyncIterator<IteratorItem<TableKey<KeyT>>> keyIterator(@NonNull String var1, int var2, @Nullable IteratorState var3);

    public AsyncIterator<IteratorItem<TableEntry<KeyT, ValueT>>> entryIterator(@NonNull String var1, int var2, @Nullable IteratorState var3);

    @Override
    public void close();

    public KeyValueTableMap<KeyT, ValueT> getMapFor(@Nullable String var1);
}

