/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.IteratorState;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import io.pravega.shaded.io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import lombok.Generated;

public class IteratorStateImpl
implements IteratorState {
    public static final IteratorStateImpl EMPTY = new IteratorStateImpl(Unpooled.EMPTY_BUFFER);
    private final ByteBuf token;

    @Override
    public ByteBuffer toBytes() {
        return this.token.copy().nioBuffer();
    }

    @Override
    public boolean isEmpty() {
        return this.token.readableBytes() == 0;
    }

    public static IteratorStateImpl fromBytes(ByteBuf serializedState) {
        if (serializedState == null || serializedState.readableBytes() == 0) {
            return EMPTY;
        }
        return new IteratorStateImpl(serializedState);
    }

    public static IteratorStateImpl fromBytes(ByteBuffer serializedState) {
        if (serializedState == null) {
            return EMPTY;
        }
        return IteratorStateImpl.fromBytes(Unpooled.wrappedBuffer(serializedState));
    }

    public static IteratorStateImpl copyOf(IteratorState source) {
        if (source == null || source == EMPTY) {
            return EMPTY;
        }
        return IteratorStateImpl.fromBytes(source.toBytes());
    }

    @ConstructorProperties(value={"token"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private IteratorStateImpl(ByteBuf token) {
        this.token = token;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuf getToken() {
        return this.token;
    }
}

