/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import io.pravega.shaded.io.netty.buffer.Unpooled;
import io.pravega.shaded.org.apache.commons.lang3.SerializationException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import lombok.NonNull;

class KeyFamilySerializer {
    @VisibleForTesting
    static final int MAX_KEY_FAMILY_LENGTH = 2048;
    @VisibleForTesting
    static final int PREFIX_LENGTH = 2;
    @VisibleForTesting
    static final Charset ENCODING = StandardCharsets.UTF_8;

    KeyFamilySerializer() {
    }

    ByteBuf serialize(@Nullable String keyFamily) {
        ByteBuf prefix = Unpooled.wrappedBuffer(new byte[2]);
        if (keyFamily == null || keyFamily.length() == 0) {
            prefix.setShort(0, 0);
            return prefix;
        }
        ByteBuffer s2 = ENCODING.encode(keyFamily);
        Preconditions.checkArgument(s2.remaining() <= 2048, "KeyFamily must have a %s encoding length of at most %s bytes; actual %s.", (Object)ENCODING.name(), (Object)2048, (Object)s2.remaining());
        prefix.setShort(0, s2.remaining());
        return Unpooled.wrappedBuffer(prefix, Unpooled.wrappedBuffer(s2));
    }

    String deserialize(@NonNull ByteBuf serializedValue) {
        if (serializedValue == null) {
            throw new NullPointerException("serializedValue is marked non-null but is null");
        }
        if (serializedValue.readableBytes() < 2) {
            throw new SerializationException(String.format("At least %d bytes required, given %d.", 2, serializedValue.readableBytes()));
        }
        short kfLength = serializedValue.readShort();
        if (kfLength < 0 || kfLength > 2048) {
            throw new SerializationException(String.format("Invalid Key Family Length. Expected between %d and %d, read %d.", 0, 2048, (int)kfLength));
        }
        if (serializedValue.readableBytes() < kfLength) {
            throw new SerializationException(String.format("Insufficient bytes remaining in buffer. Expected at least %d, actual %d.", kfLength, serializedValue.readableBytes()));
        }
        if (kfLength == 0) {
            return null;
        }
        String result = ENCODING.decode(serializedValue.nioBuffer(serializedValue.readerIndex(), kfLength)).toString();
        serializedValue.readerIndex(serializedValue.readerIndex() + kfLength);
        return result;
    }
}

