/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import io.pravega.client.admin.KeyValueTableInfo;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.tables.impl.KeyValueTableSegments;
import io.pravega.client.tables.impl.TableSegment;
import io.pravega.client.tables.impl.TableSegmentFactory;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import lombok.NonNull;

class SegmentSelector
implements AutoCloseable {
    private final TableSegmentFactory tableSegmentFactory;
    private final KeyValueTableSegments segmentsByRange;
    @GuardedBy(value="segments")
    private final Map<Segment, TableSegment> segments = new HashMap<Segment, TableSegment>();
    private final AtomicBoolean closed;

    SegmentSelector(@NonNull KeyValueTableInfo kvt, @NonNull Controller controller, @NonNull TableSegmentFactory tableSegmentFactory) {
        if (kvt == null) {
            throw new NullPointerException("kvt is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (tableSegmentFactory == null) {
            throw new NullPointerException("tableSegmentFactory is marked non-null but is null");
        }
        this.tableSegmentFactory = tableSegmentFactory;
        this.segmentsByRange = this.initializeSegments(kvt, controller);
        assert (this.segmentsByRange != null);
        this.closed = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            ArrayList<TableSegment> toClose;
            Map<Segment, TableSegment> map = this.segments;
            synchronized (map) {
                toClose = new ArrayList<TableSegment>(this.segments.values());
                this.segments.clear();
            }
            toClose.forEach(TableSegment::close);
        }
    }

    TableSegment getTableSegment(@NonNull String keyFamily) {
        if (keyFamily == null) {
            throw new NullPointerException("keyFamily is marked non-null but is null");
        }
        return this.getTableSegment(keyFamily, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableSegment getTableSegment(String keyFamily, ByteBuf key) {
        Exceptions.checkNotClosed(this.closed.get(), this);
        assert (keyFamily != null || key != null);
        Segment s2 = keyFamily == null ? this.segmentsByRange.getSegmentForKey(key) : this.segmentsByRange.getSegmentForKey(keyFamily);
        Map<Segment, TableSegment> map = this.segments;
        synchronized (map) {
            TableSegment ts = this.segments.get(s2);
            if (ts == null) {
                ts = this.tableSegmentFactory.forSegment(s2);
                this.segments.put(s2, ts);
            }
            return ts;
        }
    }

    int getSegmentCount() {
        return this.segmentsByRange.getSegmentCount();
    }

    private KeyValueTableSegments initializeSegments(KeyValueTableInfo kvt, Controller controller) {
        return Futures.getAndHandleExceptions(controller.getCurrentSegmentsForKeyValueTable(kvt.getScope(), kvt.getKeyValueTableName()), RuntimeException::new);
    }
}

