/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import io.pravega.client.tables.IteratorItem;
import io.pravega.client.tables.impl.IteratorArgs;
import io.pravega.client.tables.impl.TableSegmentEntry;
import io.pravega.client.tables.impl.TableSegmentKey;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import io.pravega.common.util.AsyncIterator;
import io.pravega.shaded.com.google.common.collect.Iterators;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public interface TableSegment
extends AutoCloseable {
    public static final int MAXIMUM_KEY_LENGTH = 8192;
    public static final int MAXIMUM_VALUE_LENGTH = 1040384;
    public static final int MAXIMUM_BATCH_KEY_COUNT = 256;
    public static final int MAXIMUM_BATCH_LENGTH = 0xFFDFFF;

    default public CompletableFuture<TableSegmentKeyVersion> put(TableSegmentEntry entry) {
        return this.put(Iterators.singletonIterator(entry)).thenApply(result -> (TableSegmentKeyVersion)result.get(0));
    }

    public CompletableFuture<List<TableSegmentKeyVersion>> put(Iterator<TableSegmentEntry> var1);

    default public CompletableFuture<Void> remove(TableSegmentKey key) {
        return this.remove(Iterators.singletonIterator(key));
    }

    public CompletableFuture<Void> remove(Iterator<TableSegmentKey> var1);

    default public CompletableFuture<TableSegmentEntry> get(ByteBuf key) {
        return this.get(Iterators.singletonIterator(key)).thenApply(result -> (TableSegmentEntry)result.get(0));
    }

    public CompletableFuture<List<TableSegmentEntry>> get(Iterator<ByteBuf> var1);

    public AsyncIterator<IteratorItem<TableSegmentKey>> keyIterator(IteratorArgs var1);

    public AsyncIterator<IteratorItem<TableSegmentEntry>> entryIterator(IteratorArgs var1);

    public long getSegmentId();

    @Override
    public void close();
}

