/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.impl.TableSegmentKey;
import io.pravega.client.tables.impl.TableSegmentKeyVersion;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import io.pravega.shaded.io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

public class TableSegmentEntry {
    @NonNull
    private final TableSegmentKey key;
    private final ByteBuf value;

    public static TableSegmentEntry unversioned(ByteBuf key, ByteBuf value) {
        return new TableSegmentEntry(new TableSegmentKey(key, TableSegmentKeyVersion.NO_VERSION), value);
    }

    public static TableSegmentEntry unversioned(byte[] key, byte[] value) {
        return TableSegmentEntry.unversioned(Unpooled.wrappedBuffer(key), Unpooled.wrappedBuffer(value));
    }

    public static TableSegmentEntry versioned(ByteBuf key, ByteBuf value, long version) {
        return new TableSegmentEntry(new TableSegmentKey(key, TableSegmentKeyVersion.from(version)), value);
    }

    public static TableSegmentEntry versioned(byte[] key, byte[] value, long version) {
        return TableSegmentEntry.versioned(Unpooled.wrappedBuffer(key), Unpooled.wrappedBuffer(value), version);
    }

    public static TableSegmentEntry notExists(ByteBuf key, ByteBuf value) {
        return new TableSegmentEntry(new TableSegmentKey(key, TableSegmentKeyVersion.NOT_EXISTS), value);
    }

    public static TableSegmentEntry notExists(byte[] key, byte[] value) {
        return TableSegmentEntry.notExists(Unpooled.wrappedBuffer(key), Unpooled.wrappedBuffer(value));
    }

    public static TableSegmentEntry notFound(ByteBuf key) {
        return new TableSegmentEntry(TableSegmentKey.notExists(key), null);
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TableSegmentKey getKey() {
        return this.key;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteBuf getValue() {
        return this.value;
    }

    @ConstructorProperties(value={"key", "value"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    TableSegmentEntry(@NonNull TableSegmentKey key, ByteBuf value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.value = value;
    }
}

