/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import io.pravega.client.tables.IteratorItem;
import io.pravega.client.tables.IteratorState;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import lombok.NonNull;

class TableSegmentIterator<T>
implements AsyncIterator<IteratorItem<T>> {
    private final Function<IteratorState, CompletableFuture<IteratorItem<T>>> fetchNext;
    private final AtomicReference<IteratorState> state;
    private final AtomicBoolean closed;

    TableSegmentIterator(@NonNull Function<IteratorState, CompletableFuture<IteratorItem<T>>> fetchNext, IteratorState initialState) {
        if (fetchNext == null) {
            throw new NullPointerException("fetchNext is marked non-null but is null");
        }
        this.fetchNext = fetchNext;
        this.state = new AtomicReference<IteratorState>(initialState);
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public CompletableFuture<IteratorItem<T>> getNext() {
        if (this.closed.get()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage result = this.fetchNext.apply(this.state.get()).thenApply((T r) -> {
            if (r == null) {
                this.state.set(null);
                this.closed.set(true);
                return null;
            }
            this.state.set(r.getState());
            return r;
        });
        Futures.exceptionListener(result, ObjectClosedException.class, ex -> this.closed.set(true));
        return result;
    }
}

