/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.ByteBufferUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lombok.Generated;

public class TableSegmentKeyVersion
implements Serializable {
    public static final TableSegmentKeyVersion NOT_EXISTS = new NotExists();
    public static final TableSegmentKeyVersion NO_VERSION = new TableSegmentKeyVersion(Long.MIN_VALUE);
    private static final Serializer SERIALIZER = new Serializer();
    private final long segmentVersion;

    private TableSegmentKeyVersion(long segmentVersion) {
        this.segmentVersion = segmentVersion;
    }

    public static TableSegmentKeyVersion from(long segmentVersion) {
        if (segmentVersion == NOT_EXISTS.getSegmentVersion()) {
            return NOT_EXISTS;
        }
        if (segmentVersion == NO_VERSION.getSegmentVersion()) {
            return NO_VERSION;
        }
        return new TableSegmentKeyVersion(segmentVersion);
    }

    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static TableSegmentKeyVersion fromBytes(ByteBuffer serializedKeyVersion) {
        if (!serializedKeyVersion.hasRemaining()) {
            return NOT_EXISTS;
        }
        return (TableSegmentKeyVersion)SERIALIZER.deserialize(new ByteArraySegment(serializedKeyVersion));
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(SERIALIZER.serialize(this).getCopy());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static TableSegmentKeyVersionBuilder builder() {
        return new TableSegmentKeyVersionBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getSegmentVersion() {
        return this.segmentVersion;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableSegmentKeyVersion)) {
            return false;
        }
        TableSegmentKeyVersion other = (TableSegmentKeyVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSegmentVersion() == other.getSegmentVersion();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableSegmentKeyVersion;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $segmentVersion = this.getSegmentVersion();
        result = result * 59 + (int)($segmentVersion >>> 32 ^ $segmentVersion);
        return result;
    }

    private static class NotExists
    extends TableSegmentKeyVersion {
        NotExists() {
            super(-1L);
        }

        @Override
        public ByteBuffer toBytes() {
            return ByteBufferUtils.EMPTY;
        }

        public String toString() {
            return "NOT_EXISTS";
        }

        private Object readResolve() {
            return NOT_EXISTS;
        }
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] value;

        Object readResolve() throws ObjectStreamException {
            return SERIALIZER.deserialize(new ByteArraySegment(this.value));
        }

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SerializedForm(byte[] value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte[] getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedForm)) {
                return false;
            }
            SerializedForm other = (SerializedForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SerializedForm;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TableSegmentKeyVersion.SerializedForm(value=" + Arrays.toString(this.getValue()) + ")";
        }
    }

    static class Serializer
    extends VersionedSerializer.WithBuilder<TableSegmentKeyVersion, TableSegmentKeyVersionBuilder> {
        Serializer() {
        }

        @Override
        protected TableSegmentKeyVersionBuilder newBuilder() {
            return TableSegmentKeyVersion.builder();
        }

        @Override
        protected byte getWriteVersion() {
            return 0;
        }

        @Override
        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, TableSegmentKeyVersionBuilder builder) throws IOException {
            builder.segmentVersion(revisionDataInput.readLong());
        }

        private void write00(TableSegmentKeyVersion version, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(version.getSegmentVersion());
        }
    }

    private static class TableSegmentKeyVersionBuilder
    implements ObjectBuilder<TableSegmentKeyVersion> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long segmentVersion;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TableSegmentKeyVersionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableSegmentKeyVersionBuilder segmentVersion(long segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TableSegmentKeyVersion build() {
            return new TableSegmentKeyVersion(this.segmentVersion);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "TableSegmentKeyVersion.TableSegmentKeyVersionBuilder(segmentVersion=" + this.segmentVersion + ")";
        }
    }
}

