/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common;

import io.pravega.common.ObjectClosedException;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public final class Exceptions {
    public static RuntimeException sneakyThrow(Throwable t) {
        throw t;
    }

    public static boolean mustRethrow(Throwable ex) {
        return ex instanceof VirtualMachineError;
    }

    public static Throwable unwrap(Throwable ex) {
        Throwable cause;
        if (Exceptions.canInspectCause(ex) && (cause = ex.getCause()) != null) {
            return Exceptions.unwrap(cause);
        }
        return ex;
    }

    public static boolean shouldUnwrap(Class<? extends Exception> c) {
        return c.equals(CompletionException.class) || c.equals(ExecutionException.class);
    }

    private static boolean canInspectCause(Throwable ex) {
        return ex instanceof CompletionException || ex instanceof ExecutionException;
    }

    public static <ExceptionT extends Exception> void handleInterrupted(InterruptibleRun<ExceptionT> run) throws ExceptionT {
        try {
            run.run();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public static <ExceptionT extends Exception, ResultT> ResultT handleInterruptedCall(InterruptibleCall<ExceptionT, ResultT> call) throws ExceptionT {
        try {
            return call.call();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    public static String checkNotNullOrEmpty(String arg, String argName) throws NullPointerException, IllegalArgumentException {
        Preconditions.checkNotNull(arg, argName);
        Exceptions.checkArgument(arg.length() > 0, argName, "Cannot be an empty string.", new Object[0]);
        return arg;
    }

    public static <T, V extends Collection<T>> V checkNotNullOrEmpty(V arg, String argName) throws NullPointerException, IllegalArgumentException {
        Preconditions.checkNotNull(arg, argName);
        Exceptions.checkArgument(!arg.isEmpty(), argName, "Cannot be an empty collection.", new Object[0]);
        return arg;
    }

    public static <K, V> Map<K, V> checkNotNullOrEmpty(Map<K, V> arg, String argName) throws NullPointerException, IllegalArgumentException {
        Preconditions.checkNotNull(arg, argName);
        Exceptions.checkArgument(!arg.isEmpty(), argName, "Cannot be an empty map.", new Object[0]);
        return arg;
    }

    public static void checkArgument(boolean validCondition, String argName, String message, Object ... args) throws IllegalArgumentException {
        if (!validCondition) {
            throw new IllegalArgumentException(Exceptions.badArgumentMessage(argName, message, args));
        }
    }

    public static void checkArrayRange(long startIndex, int length, long arrayLength, String startIndexArgName, String lengthArgName) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException(Exceptions.badArgumentMessage(lengthArgName, "length must be a non-negative integer.", new Object[0]));
        }
        if (!(startIndex >= 0L && startIndex < arrayLength || startIndex == 0L && length == 0 && arrayLength == 0L)) {
            throw new ArrayIndexOutOfBoundsException(Exceptions.badStartOffsetMessage(startIndex, arrayLength, startIndexArgName));
        }
        if (startIndex + (long)length > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(Exceptions.badLengthMessage(startIndex, length, arrayLength, startIndexArgName, lengthArgName));
        }
    }

    public static void checkNotClosed(boolean closed, Object targetObject) throws ObjectClosedException {
        if (closed) {
            throw new ObjectClosedException(targetObject);
        }
    }

    private static String badArgumentMessage(String argName, String message, Object ... args) {
        return argName + ": " + String.format(message, args);
    }

    private static String badStartOffsetMessage(long startIndex, long arrayLength, String startIndexArgName) {
        return String.format("%s: value must be in interval [0, %d), given %d.", startIndexArgName, arrayLength, startIndex);
    }

    private static String badLengthMessage(long startIndex, int length, long arrayLength, String startIndexArgName, String lengthArgName) {
        return String.format("%s + %s: value must be in interval [0, %d], actual %d.", startIndexArgName, lengthArgName, arrayLength, startIndex + (long)length);
    }

    @FunctionalInterface
    public static interface InterruptibleCall<ExceptionT extends Exception, ResultT> {
        public ResultT call() throws InterruptedException, ExceptionT;
    }

    @FunctionalInterface
    public static interface InterruptibleRun<ExceptionT extends Exception> {
        public void run() throws InterruptedException, ExceptionT;
    }
}

