/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.concurrent.Services;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.com.google.common.util.concurrent.AbstractService;
import io.pravega.shaded.com.google.common.util.concurrent.Service;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThreadPoolService
extends AbstractService
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractThreadPoolService.class);
    protected final String traceObjectId;
    protected final ScheduledExecutorService executor;
    private final AtomicReference<Throwable> stopException;
    private CompletableFuture<Void> runTask;
    private final AtomicBoolean closed;

    public AbstractThreadPoolService(String traceObjectId, ScheduledExecutorService executor) {
        Preconditions.checkNotNull(executor, "executor");
        this.traceObjectId = traceObjectId;
        this.executor = executor;
        this.stopException = new AtomicReference();
        this.closed = new AtomicBoolean();
    }

    @Override
    public void close() {
        if (!this.closed.get()) {
            Futures.await(Services.stopAsync(this, this.executor));
            log.info("{}: Closed.", (Object)this.traceObjectId);
            this.closed.set(true);
        }
    }

    @Override
    protected void doStart() {
        Exceptions.checkNotClosed(this.closed.get(), this);
        this.notifyStarted();
        log.info("{}: Started.", (Object)this.traceObjectId);
        this.runTask = this.doRun();
        this.runTask.whenComplete((r, ex) -> {
            if (!(ex == null || Exceptions.unwrap(ex) instanceof CancellationException && this.state() != Service.State.RUNNING)) {
                this.errorHandler((Throwable)ex);
            }
            if (this.state() == Service.State.RUNNING) {
                this.stopAsync();
            }
        });
    }

    @Override
    protected void doStop() {
        Exceptions.checkNotClosed(this.closed.get(), this);
        log.info("{}: Stopping.", (Object)this.traceObjectId);
        if (this.runTask == null) {
            this.notifyStoppedOrFailed(null);
        } else if (this.runTask.isDone()) {
            this.notifyStoppedOrFailed(Futures.getException(this.runTask));
        } else {
            CompletableFuture.anyOf(this.runTask, Futures.delayedFuture(this.getShutdownTimeout(), this.executor)).whenComplete((r, ex) -> {
                if (ex != null) {
                    ex = Exceptions.unwrap(ex);
                }
                if (ex == null && !this.runTask.isDone()) {
                    ex = new TimeoutException("Timeout expired while waiting for the Service to shut down.");
                }
                this.runTask = null;
                this.notifyStoppedOrFailed((Throwable)ex);
            });
        }
    }

    private void notifyStoppedOrFailed(Throwable runException) {
        Throwable stopException = this.stopException.get();
        if (runException == null) {
            runException = stopException;
        }
        if (runException instanceof CancellationException) {
            runException = null;
        }
        if (runException == null) {
            this.notifyStopped();
        } else {
            if (stopException != null && stopException != runException) {
                stopException.addSuppressed(runException);
                runException = stopException;
            }
            this.notifyFailed(runException);
        }
        log.info("{}: Stopped.", (Object)this.traceObjectId);
    }

    protected abstract Duration getShutdownTimeout();

    protected abstract CompletableFuture<Void> doRun();

    protected Throwable getStopException() {
        return this.stopException.get();
    }

    protected void errorHandler(Throwable ex) {
        this.stopException.compareAndSet(null, ex);
    }
}

