/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io.filesystem;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.io.filesystem.FileModificationMonitor;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import io.pravega.shaded.org.apache.commons.io.monitor.FileAlterationMonitor;
import io.pravega.shaded.org.apache.commons.io.monitor.FileAlterationObserver;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileModificationPollingMonitor
implements FileModificationMonitor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileModificationPollingMonitor.class);
    @VisibleForTesting
    static final int DEFAULT_POLL_INTERVAL = 10000;
    private final Path pathOfFileToWatch;
    private final Consumer<File> callback;
    private final FileAlterationMonitor monitor;
    @VisibleForTesting
    private final int pollingInterval;

    public FileModificationPollingMonitor(@NonNull Path fileToWatch, @NonNull Consumer<File> callback) throws FileNotFoundException {
        this(fileToWatch, callback, 10000, true);
        if (fileToWatch == null) {
            throw new NullPointerException("fileToWatch is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
    }

    @VisibleForTesting
    FileModificationPollingMonitor(@NonNull Path fileToWatch, @NonNull Consumer<File> callback, int pollingInterval, boolean checkForFileExistence) throws FileNotFoundException {
        if (fileToWatch == null) {
            throw new NullPointerException("fileToWatch is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        Exceptions.checkNotNullOrEmpty(fileToWatch.toString(), "fileToWatch");
        if (checkForFileExistence && !fileToWatch.toFile().exists()) {
            throw new FileNotFoundException(String.format("File [%s] does not exist.", fileToWatch));
        }
        this.pathOfFileToWatch = fileToWatch;
        this.callback = callback;
        this.pollingInterval = pollingInterval;
        this.monitor = new FileAlterationMonitor(this.pollingInterval);
    }

    @Override
    public void startMonitoring() {
        final Path fileName = this.pathOfFileToWatch.getFileName();
        log.debug("File name obtained from pathOfFileToWatch is [{}]", (Object)fileName);
        if (fileName == null) {
            throw new IllegalStateException("fileName is 'null'");
        }
        Path dirPath = this.pathOfFileToWatch.getParent();
        log.debug("dirPath is [{}]", (Object)dirPath);
        if (dirPath == null) {
            throw new IllegalStateException("The directory containing the file turned out to be 'null`");
        }
        FileAlterationObserver observer = new FileAlterationObserver(dirPath.toString(), new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null || file.getName() == null) {
                    return false;
                }
                return file.getName().equals(fileName.toString());
            }
        });
        FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor(){

            @Override
            public void onFileChange(File file) {
                log.info("Detected that the file [{}] has modified", (Object)file.getPath());
                FileModificationPollingMonitor.this.callback.accept(file);
            }
        };
        observer.addListener(listener);
        this.monitor.addObserver(observer);
        try {
            this.monitor.start();
            log.info("Done setting up file modification monitor for file [{}]", (Object)this.pathOfFileToWatch);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stopMonitoring() {
        if (this.monitor != null) {
            try {
                this.monitor.stop(5000L);
            }
            catch (Exception e) {
                log.warn("Failed to close the monitor", (Throwable)e);
            }
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPollingInterval() {
        return this.pollingInterval;
    }
}

