/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.io.serialization;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.io.DirectDataOutput;
import io.pravega.common.io.SerializationException;
import io.pravega.common.io.serialization.RandomAccessOutputStream;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.util.BitConverter;
import io.pravega.common.util.BufferView;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.ToIntFunction;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
abstract class RevisionDataOutputStream
extends FilterOutputStream
implements RevisionDataOutput {
    private DirectDataOutput structuredWriter;
    private int size;

    private RevisionDataOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.structuredWriter = this.out instanceof DirectDataOutput ? (DirectDataOutput)((Object)this.out) : new IndirectWriter();
        this.size = 0;
    }

    protected final void setOut(OutputStream out, int length) throws IOException {
        this.out = out;
        this.structuredWriter = out instanceof DirectDataOutput ? (DirectDataOutput)((Object)out) : new IndirectWriter();
        this.structuredWriter.writeInt(length);
    }

    public static RevisionDataOutputStream wrap(OutputStream outputStream) throws IOException {
        if (outputStream instanceof RandomAccessOutputStream) {
            return new RandomRevisionDataOutput(outputStream);
        }
        return new NonSeekableRevisionDataOutput(outputStream);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.size;
    }

    @Override
    public void write(byte[] array, int off, int len) throws IOException {
        this.out.write(array, off, len);
        this.size += len;
    }

    @Override
    public final void writeBoolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    @Override
    public final void writeByte(int b) throws IOException {
        this.write(b);
    }

    @Override
    public void writeChar(int c) throws IOException {
        this.writeShort(c);
    }

    @Override
    public void writeShort(int s2) throws IOException {
        this.structuredWriter.writeShort(s2);
        this.size += 2;
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.structuredWriter.writeInt(i);
        this.size += 4;
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.structuredWriter.writeLong(l);
        this.size += 8;
    }

    @Override
    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    @Override
    public void writeBytes(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            this.out.write((byte)s2.charAt(i));
        }
        this.size += len;
    }

    @Override
    public final void writeChars(String s2) throws IOException {
        int len = s2.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(s2.charAt(i));
        }
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        char c;
        int i;
        int stringLength = str.length();
        int utfLength = this.getUTFLength(str) - 2;
        Preconditions.checkArgument(utfLength <= 65535, "Encoded string too long: %s bytes", utfLength);
        byte[] byteArray = new byte[utfLength + 2];
        int index = 0;
        byteArray[index++] = (byte)(utfLength >>> 8 & 0xFF);
        byteArray[index++] = (byte)(utfLength >>> 0 & 0xFF);
        for (i = 0; i < stringLength && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            byteArray[index++] = (byte)c;
        }
        while (i < stringLength) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                byteArray[index++] = (byte)c;
            } else if (c > '\u07ff') {
                byteArray[index++] = (byte)(0xE0 | c >> 12 & 0xF);
                byteArray[index++] = (byte)(0x80 | c >> 6 & 0x3F);
                byteArray[index++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                byteArray[index++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byteArray[index++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.write(byteArray);
    }

    @Override
    public int getUTFLength(String s2) {
        int charCount = s2.length();
        int length = 2;
        for (int i = 0; i < charCount; ++i) {
            char c = s2.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++length;
                continue;
            }
            if (c > '\u07ff') {
                length += 3;
                continue;
            }
            length += 2;
        }
        return length;
    }

    @Override
    public int getCompactLongLength(long value) {
        if (value < 0L || value > 0x3FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactLong", "longs", "[0, 2^62)", value));
        }
        if (value > 0x3FFFFFFFL) {
            return 8;
        }
        if (value > 16383L) {
            return 4;
        }
        if (value > 63L) {
            return 2;
        }
        return 1;
    }

    @Override
    public void writeCompactLong(long value) throws IOException {
        if (value < 0L || value > 0x3FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactLong", "longs", "[0, 2^62)", value));
        }
        if (value > 0x3FFFFFFFL) {
            this.writeInt((int)(value >>> 32 | 0xFFFFFFFFC0000000L));
            this.writeInt((int)value);
        } else if (value > 16383L) {
            this.writeInt((int)(value | Integer.MIN_VALUE));
        } else if (value > 63L) {
            this.writeShort((short)(value | 0x4000L));
        } else {
            this.writeByte((byte)value);
        }
    }

    @Override
    public int getCompactSignedLongLength(long value) {
        if (value < -2305843009213693951L || value > 0x1FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactSignedLong", "longs", "[-2^61, 2^61)", value));
        }
        if (value < 0L) {
            value = RevisionDataOutputStream.negateSignedNumber(value);
        }
        if (value > 0x1FFFFFFFL) {
            return 8;
        }
        if (value > 8191L) {
            return 4;
        }
        if (value > 31L) {
            return 2;
        }
        return 1;
    }

    @Override
    public void writeCompactSignedLong(long value) throws IOException {
        boolean negative;
        if (value < -2305843009213693951L || value > 0x1FFFFFFFFFFFFFFEL) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactSignedLong", "longs", "[-2^61, 2^61)", value));
        }
        boolean bl = negative = value < 0L;
        if (negative) {
            value = RevisionDataOutputStream.negateSignedNumber(value);
        }
        if (value > 0x1FFFFFFFL) {
            this.writeInt((int)(value >>> 32 | (long)(negative ? -536870912 : 0x60000000)));
            this.writeInt((int)value);
        } else if (value > 8191L) {
            this.writeInt((int)(value | (long)(negative ? -1073741824 : 0x40000000)));
        } else if (value > 31L) {
            this.writeShort((short)(value | (long)(negative ? 40960 : 8192)));
        } else if (negative) {
            this.writeByte((byte)value | 0x80);
        } else {
            this.writeByte((byte)value);
        }
    }

    @Override
    public int getCompactIntLength(int value) {
        if (value < 0 || value > 0x3FFFFFFE) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactInt", "ints", "[0, 2^30)", value));
        }
        if (value > 16383) {
            return 4;
        }
        if (value > 127) {
            return 2;
        }
        return 1;
    }

    @Override
    public void writeCompactInt(int value) throws IOException {
        if (value < 0 || value > 0x3FFFFFFE) {
            throw new IllegalArgumentException(this.badArgRange("writeCompactInt", "ints", "[0, 2^30)", value));
        }
        if (value > 16383) {
            this.writeInt(value | 0xC0000000);
        } else if (value > 127) {
            this.writeShort((short)(value | 0x8000));
        } else {
            this.writeByte((byte)value);
        }
    }

    @Override
    public void writeUUID(UUID uuid) throws IOException {
        this.writeLong(uuid.getMostSignificantBits());
        this.writeLong(uuid.getLeastSignificantBits());
    }

    @Override
    public int getCollectionLength(int elementCount, int elementLength) {
        return this.getCompactIntLength(elementCount) + elementCount * elementLength;
    }

    @Override
    public <T> int getCollectionLength(Collection<T> collection, ToIntFunction<T> elementLengthProvider) {
        if (collection == null) {
            return this.getCompactIntLength(0);
        }
        return this.getCompactIntLength(collection.size()) + collection.stream().mapToInt(elementLengthProvider).sum();
    }

    @Override
    public <T> int getCollectionLength(T[] array, ToIntFunction<T> elementLengthProvider) {
        if (array == null) {
            return this.getCompactIntLength(0);
        }
        return this.getCompactIntLength(array.length) + Arrays.stream(array).mapToInt(elementLengthProvider).sum();
    }

    @Override
    public <T> void writeCollection(Collection<T> collection, RevisionDataOutput.ElementSerializer<T> elementSerializer) throws IOException {
        if (collection == null) {
            this.writeCompactInt(0);
            return;
        }
        this.writeCompactInt(collection.size());
        for (T e : collection) {
            elementSerializer.accept(this, e);
        }
    }

    @Override
    public <T> void writeArray(T[] array, RevisionDataOutput.ElementSerializer<T> elementSerializer) throws IOException {
        if (array == null) {
            this.writeCompactInt(0);
            return;
        }
        this.writeCompactInt(array.length);
        for (T e : array) {
            elementSerializer.accept(this, e);
        }
    }

    @Override
    public void writeArray(byte[] array, int offset, int length) throws IOException {
        if (array == null) {
            this.writeCompactInt(0);
            return;
        }
        if (offset < 0 || offset > array.length || length < 0 || offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException("offset and length must refer to a range within the given array.");
        }
        this.writeCompactInt(length);
        this.write(array, offset, length);
    }

    @Override
    public void writeBuffer(BufferView buf) throws IOException {
        if (buf == null) {
            this.writeCompactInt(0);
            return;
        }
        this.writeCompactInt(buf.getLength());
        this.structuredWriter.writeBuffer(buf);
        this.size += buf.getLength();
    }

    @Override
    public int getMapLength(int elementCount, int keyLength, int valueLength) {
        return this.getCompactIntLength(elementCount) + elementCount * (keyLength + valueLength);
    }

    @Override
    public <K, V> int getMapLength(Map<K, V> map, ToIntFunction<K> keyLengthProvider, ToIntFunction<V> valueLengthProvider) {
        if (map == null) {
            return this.getCompactIntLength(0);
        }
        return this.getCompactIntLength(map.size()) + map.entrySet().stream().mapToInt(e -> keyLengthProvider.applyAsInt(e.getKey()) + valueLengthProvider.applyAsInt(e.getValue())).sum();
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map, RevisionDataOutput.ElementSerializer<K> keySerializer, RevisionDataOutput.ElementSerializer<V> valueSerializer) throws IOException {
        if (map == null) {
            this.writeCompactInt(0);
            return;
        }
        this.writeCompactInt(map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            keySerializer.accept(this, e.getKey());
            valueSerializer.accept(this, e.getValue());
        }
    }

    private <T> String badArgRange(String methodName, String type, String interval, T arg) {
        return String.format("%s can only serialize %s in the interval %s, given %s.", methodName, type, interval, arg);
    }

    static long negateSignedNumber(long value) {
        return -value - 1L;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getSize() {
        return this.size;
    }

    @NotThreadSafe
    private static class NonSeekableRevisionDataOutput
    extends RevisionDataOutputStream {
        private final OutputStream realStream;
        private int length;

        NonSeekableRevisionDataOutput(OutputStream outputStream) {
            super(new LengthRequiredOutputStream());
            this.realStream = outputStream;
            this.length = 0;
        }

        @Override
        public void close() throws IOException {
            if (this.length != this.getSize()) {
                throw new SerializationException(String.format("Unexpected number of bytes written. Declared: %d, written: %d.", this.length, this.getSize()));
            }
            if (this.requiresExplicitLength()) {
                this.length(0);
            }
        }

        @Override
        public OutputStream getBaseStream() {
            return this;
        }

        @Override
        public boolean requiresExplicitLength() {
            return this.out instanceof LengthRequiredOutputStream;
        }

        @Override
        public void length(int length) throws IOException {
            if (this.requiresExplicitLength()) {
                this.setOut(this.realStream, length);
                this.length = length;
            }
        }

        private static class LengthRequiredOutputStream
        extends OutputStream {
            private LengthRequiredOutputStream() {
            }

            @Override
            public void write(int i) {
                throw new IllegalStateException("Length must be declared prior to writing anything.");
            }

            @Override
            public void write(byte[] buffer, int index, int length) {
                throw new IllegalStateException("Length must be declared prior to writing anything.");
            }
        }
    }

    private static class RandomRevisionDataOutput
    extends RevisionDataOutputStream {
        private final int initialPosition;

        RandomRevisionDataOutput(OutputStream outputStream) throws IOException {
            super(outputStream);
            RandomAccessOutputStream ros = (RandomAccessOutputStream)((Object)outputStream);
            this.initialPosition = ros.size();
            ros.writeInt(0);
        }

        @Override
        public void close() throws IOException {
            RandomAccessOutputStream ros = (RandomAccessOutputStream)((Object)this.out);
            int length = ros.size() - this.initialPosition - 4;
            ros.writeInt(length, this.initialPosition);
        }

        @Override
        public OutputStream getBaseStream() {
            return this.out;
        }

        @Override
        public boolean requiresExplicitLength() {
            return false;
        }

        @Override
        public void length(int length) throws IOException {
        }
    }

    private class IndirectWriter
    implements DirectDataOutput {
        private IndirectWriter() {
        }

        @Override
        public void writeShort(int shortValue) throws IOException {
            BitConverter.writeShort(RevisionDataOutputStream.this.out, (short)shortValue);
        }

        @Override
        public void writeInt(int intValue) throws IOException {
            BitConverter.writeInt(RevisionDataOutputStream.this.out, intValue);
        }

        @Override
        public void writeLong(long longValue) throws IOException {
            BitConverter.writeLong(RevisionDataOutputStream.this.out, longValue);
        }

        @Override
        public void writeBuffer(BufferView buffer) throws IOException {
            buffer.copyTo(RevisionDataOutputStream.this);
            RevisionDataOutputStream.this.size -= buffer.getLength();
        }
    }
}

