/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.lang;

import io.pravega.shaded.com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ProcessStarter {
    private final Class<?> target;
    private final ProcessBuilder builder;
    private final HashMap<String, String> systemProps;
    private Object[] args;

    private ProcessStarter(Class<?> target) {
        this.target = Preconditions.checkNotNull(target, "target");
        this.builder = new ProcessBuilder(new String[0]).inheritIO();
        this.systemProps = new HashMap();
    }

    public static ProcessStarter forClass(Class<?> target) {
        return new ProcessStarter(target);
    }

    public ProcessStarter sysProp(String name, Object value) {
        this.systemProps.put(name, value.toString());
        return this;
    }

    public ProcessStarter env(String name, Object value) {
        this.builder.environment().put(name, value.toString());
        return this;
    }

    public ProcessStarter stdOut(ProcessBuilder.Redirect redirect) {
        this.builder.redirectOutput(redirect);
        return this;
    }

    public ProcessStarter stdErr(ProcessBuilder.Redirect redirect) {
        this.builder.redirectError(redirect);
        return this;
    }

    public ProcessStarter stdIn(ProcessBuilder.Redirect redirect) {
        this.builder.redirectInput(redirect);
        return this;
    }

    public ProcessStarter args(Object ... args) {
        this.args = args;
        return this;
    }

    public Process start() throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java");
        cmd.add("-cp");
        cmd.add(System.getProperty("java.class.path"));
        for (Map.Entry<String, String> e : this.systemProps.entrySet()) {
            cmd.add(String.format("-D%s=%s", e.getKey(), e.getValue()));
        }
        cmd.add(this.target.getCanonicalName());
        if (this.args != null) {
            for (Object arg : this.args) {
                cmd.add(arg.toString());
            }
        }
        this.builder.command(cmd);
        return this.builder.start();
    }
}

