/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.Exceptions;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;

public abstract class AbstractDrainingQueue<T> {
    @GuardedBy(value="lock")
    private CompletableFuture<Queue<T>> pendingTake;
    @GuardedBy(value="lock")
    private boolean closed;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<T> close() {
        CompletableFuture<Queue<T>> pending = null;
        ArrayDeque<T> result = new ArrayDeque<T>();
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                int remainingSize;
                this.closed = true;
                pending = this.pendingTake;
                this.pendingTake = null;
                while ((remainingSize = this.size()) > 0) {
                    result.addAll(this.fetch(remainingSize));
                }
            }
        }
        if (pending != null) {
            pending.cancel(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPendingTake() {
        CompletableFuture<Queue<T>> pending;
        Object object = this.lock;
        synchronized (object) {
            pending = this.pendingTake;
            this.pendingTake = null;
        }
        if (pending != null) {
            pending.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T item) {
        CompletableFuture<Queue<Queue<T>>> pending;
        Queue<T> result = null;
        Object object = this.lock;
        synchronized (object) {
            Exceptions.checkNotClosed(this.closed, this);
            this.addInternal(item);
            pending = this.pendingTake;
            this.pendingTake = null;
            if (pending != null) {
                result = this.fetch(this.size());
            }
        }
        if (pending != null) {
            pending.complete(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<T> poll(int maxCount) {
        Object object = this.lock;
        synchronized (object) {
            Exceptions.checkNotClosed(this.closed, this);
            Preconditions.checkState(this.pendingTake == null, "Cannot call poll() when there is a pending take() request.");
            return this.fetch(maxCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Queue<T>> take(int maxCount) {
        Object object = this.lock;
        synchronized (object) {
            Exceptions.checkNotClosed(this.closed, this);
            Preconditions.checkState(this.pendingTake == null, "Cannot have more than one concurrent pending take() request.");
            Queue<T> result = this.fetch(maxCount);
            if (result.size() > 0) {
                return CompletableFuture.completedFuture(result);
            }
            this.pendingTake = this.newTakeResult();
            return this.pendingTake;
        }
    }

    public CompletableFuture<Queue<T>> take(int maxCount, Duration timeout, ScheduledExecutorService timeoutExecutor) {
        CompletableFuture<Queue<T>> result = this.take(maxCount);
        if (!result.isDone()) {
            ScheduledFuture<?> sf = timeoutExecutor.schedule(() -> {
                Object object = this.lock;
                synchronized (object) {
                    if (this.pendingTake != result) {
                        return;
                    }
                    this.pendingTake = null;
                }
                result.completeExceptionally(new TimeoutException());
            }, timeout.toMillis(), TimeUnit.MILLISECONDS);
            result.whenComplete((r, ex) -> sf.cancel(true));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T peek() {
        Object object = this.lock;
        synchronized (object) {
            return this.peekInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.sizeInternal();
        }
    }

    protected abstract void addInternal(T var1);

    protected abstract int sizeInternal();

    protected abstract T peekInternal();

    protected abstract Queue<T> fetch(int var1);

    @VisibleForTesting
    protected CompletableFuture<Queue<T>> newTakeResult() {
        return new CompletableFuture<Queue<T>>();
    }
}

