/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.AsyncIterator;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;

@ThreadSafe
@VisibleForTesting
public class BlockingAsyncIterator<T>
implements Iterator<T> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private final AsyncIterator<T> asyncIterator;
    @GuardedBy(value="$lock")
    private T next = null;
    @GuardedBy(value="$lock")
    private boolean canHaveNext = true;

    public BlockingAsyncIterator(AsyncIterator<T> asyncIterator) {
        this.asyncIterator = asyncIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.next == null && this.canHaveNext) {
                this.next = this.asyncIterator.getNext().join();
                if (this.next == null) {
                    this.canHaveNext = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Object object = this.$lock;
        synchronized (object) {
            this.load();
            return this.canHaveNext;
        }
    }

    @Override
    public T next() {
        Object object = this.$lock;
        synchronized (object) {
            this.load();
            if (this.next != null) {
                T retVal = this.next;
                this.next = null;
                return retVal;
            }
            assert (!this.canHaveNext);
            throw new NoSuchElementException();
        }
    }
}

