/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.shaded.com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.NonNull;

@NotThreadSafe
public class BufferedIterator<T>
implements Iterator<T> {
    private final BiFunction<Long, Long, Iterator<T>> getItemRange;
    private final long firstIndex;
    private final long lastIndex;
    private final int batchSize;
    private long nextIndex;
    private Iterator<T> currentEntries;

    public BufferedIterator(@NonNull BiFunction<Long, Long, Iterator<T>> getItemRange, long firstIndex, long lastIndex, int batchSize) {
        if (getItemRange == null) {
            throw new NullPointerException("getItemRange is marked non-null but is null");
        }
        Preconditions.checkArgument(batchSize > 0, "batchSize must be a positive integer.");
        this.getItemRange = getItemRange;
        this.firstIndex = firstIndex;
        this.lastIndex = lastIndex;
        this.batchSize = batchSize;
        this.nextIndex = firstIndex;
        this.currentEntries = null;
    }

    @Override
    public boolean hasNext() {
        return this.currentEntries != null || this.nextIndex <= this.lastIndex;
    }

    @Override
    public T next() {
        while (this.hasNext()) {
            if (this.currentEntries != null && this.currentEntries.hasNext()) {
                T result = this.currentEntries.next();
                if (!this.currentEntries.hasNext()) {
                    this.currentEntries = null;
                }
                return result;
            }
            long readFrom = this.nextIndex;
            long readTo = Math.min(readFrom + (long)this.batchSize, this.lastIndex);
            this.nextIndex = readTo + 1L;
            assert (readFrom <= readTo);
            this.currentEntries = this.getItemRange.apply(readFrom, readTo);
            Preconditions.checkState(this.currentEntries.hasNext(), "getItemRange returned empty iterator.");
        }
        throw new NoSuchElementException();
    }
}

