/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.Exceptions;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import lombok.NonNull;

public class CertificateUtils {
    public static X509Certificate[] extractCerts(String certFilePath) throws CertificateException, IOException {
        Exceptions.checkNotNullOrEmpty(certFilePath, "certFilePath");
        try (FileInputStream is = new FileInputStream(new File(certFilePath));){
            X509Certificate[] x509CertificateArray = CertificateUtils.extractCerts(is);
            return x509CertificateArray;
        }
    }

    @VisibleForTesting
    static X509Certificate[] extractCerts(@NonNull InputStream certificateInputStream) throws CertificateException {
        if (certificateInputStream == null) {
            throw new NullPointerException("certificateInputStream is marked non-null but is null");
        }
        Collection<? extends Certificate> certificates = CertificateFactory.getInstance("X.509").generateCertificates(certificateInputStream);
        X509Certificate[] result = new X509Certificate[certificates.size()];
        int i = 0;
        for (Certificate certificate : certificates) {
            result[i++] = (X509Certificate)certificate;
        }
        return result;
    }

    public static String toString(X509Certificate[] certificateChain) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < certificateChain.length; ++i) {
            X509Certificate certificate = certificateChain[i];
            builder.append(" -> {");
            builder.append("type=[" + certificate.getType() + "], ");
            builder.append("subject=[" + certificate.getSubjectX500Principal() + "], ");
            builder.append("issuer=[" + (certificate.getIssuerDN() != null ? certificate.getIssuerDN().getName() : "None") + "]");
            builder.append("}");
        }
        return builder.toString();
    }

    public static KeyStore createTrustStore(String certFilePath) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        Exceptions.checkNotNullOrEmpty(certFilePath, "certFilePath");
        return CertificateUtils.createTrustStore(CertificateUtils.extractCerts(certFilePath));
    }

    @VisibleForTesting
    static KeyStore createTrustStore(X509Certificate[] certificateChain) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustStore.load(null, null);
        int i = 0;
        for (X509Certificate cert : certificateChain) {
            String alias = String.valueOf(i++);
            trustStore.setCertificateEntry(alias, cert);
        }
        return trustStore;
    }
}

