/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.Exceptions;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;

public class ConfigBuilder<T> {
    private final Properties properties;
    private final String namespace;
    private final ConfigConstructor<T> constructor;

    public ConfigBuilder(String namespace, ConfigConstructor<T> constructor) {
        this(namespace, new Properties(), constructor);
    }

    private ConfigBuilder(String namespace, Properties properties, ConfigConstructor<T> constructor) {
        Exceptions.checkNotNullOrEmpty(namespace, "namespace");
        Preconditions.checkNotNull(properties, "properties");
        Preconditions.checkNotNull(constructor, "constructor");
        this.properties = properties;
        this.namespace = namespace;
        this.constructor = constructor;
    }

    public ConfigBuilder<T> rebase(Properties properties) {
        return new ConfigBuilder<T>(this.namespace, properties, this.constructor);
    }

    public <V> ConfigBuilder<T> with(Property<V> property, V value) {
        String key = String.format("%s.%s", this.namespace, property.getName());
        this.properties.setProperty(key, value == null ? "" : value.toString());
        return this;
    }

    public ConfigBuilder<T> withUnsafe(Property<?> property, Object value) {
        String key = String.format("%s.%s", this.namespace, property.getName());
        this.properties.setProperty(key, value.toString());
        return this;
    }

    public void copyTo(Map<Object, Object> target) {
        target.putAll(this.properties);
    }

    public T build() throws ConfigurationException {
        return this.constructor.apply(new TypedProperties(this.properties, this.namespace));
    }

    @FunctionalInterface
    public static interface ConfigConstructor<R> {
        public R apply(TypedProperties var1) throws ConfigurationException;
    }
}

