/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationOptionsExtractor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationOptionsExtractor.class);

    @VisibleForTesting
    static String extractString(@NonNull String systemProperty, @NonNull String environmentVariable, @NonNull String defaultValue) {
        String valueFromEnv;
        if (systemProperty == null) {
            throw new NullPointerException("systemProperty is marked non-null but is null");
        }
        if (environmentVariable == null) {
            throw new NullPointerException("environmentVariable is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        String result = null;
        String valueFromSystemProperty = System.getProperty(systemProperty);
        result = valueFromSystemProperty != null && !valueFromSystemProperty.trim().equals("") ? valueFromSystemProperty : ((valueFromEnv = System.getenv(environmentVariable)) != null && valueFromEnv.trim().equals("") ? valueFromEnv : defaultValue);
        return result;
    }

    public static Integer extractInt(@NonNull String systemProperty, @NonNull String environmentVariable, @NonNull Integer defaultValue) {
        if (systemProperty == null) {
            throw new NullPointerException("systemProperty is marked non-null but is null");
        }
        if (environmentVariable == null) {
            throw new NullPointerException("environmentVariable is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        String property = ConfigurationOptionsExtractor.extractString(systemProperty, environmentVariable, String.valueOf(defaultValue));
        Integer result = null;
        try {
            result = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            log.warn("Value of the system property {} or environment variable {} is not an integer: {}", new Object[]{systemProperty, environmentVariable, property});
            result = defaultValue;
        }
        return result;
    }
}

