/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.shaded.com.google.common.base.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.ToIntFunction;

public final class EnumHelpers {
    public static <T extends Enum<T>> T[] indexById(Class<T> enumClass, ToIntFunction<T> getId) {
        Preconditions.checkArgument(enumClass.isEnum(), "Given class is not an enum.");
        Enum[] values = (Enum[])enumClass.getEnumConstants();
        Enum[] result = (Enum[])Array.newInstance(enumClass, Arrays.stream(values).mapToInt(getId).max().orElse(0) + 1);
        Enum[] enumArray = values;
        int n = enumArray.length;
        for (int i = 0; i < n; ++i) {
            Enum value;
            result[getId.applyAsInt(value)] = value = enumArray[i];
        }
        return result;
    }
}

