/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import lombok.Generated;

public final class EnvVars {
    public static int readIntegerFromEnvVar(String variableName, int defaultValue) {
        return EnvVars.readIntegerFromString(System.getenv(variableName), variableName, defaultValue);
    }

    @VisibleForTesting
    static int readIntegerFromString(String string, String variableName, int defaultValue) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Enviromental variable " + variableName + " could not be parsed as an integer");
            }
        }
        return defaultValue;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private EnvVars() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

