/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import io.pravega.common.util.AbstractDrainingQueue;
import io.pravega.common.util.SimpleDeque;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Queue;

public class PriorityBlockingDrainingQueue<T extends Item>
extends AbstractDrainingQueue<T> {
    private final SimpleDeque[] queues;
    private int firstIndex;
    private int size;

    public PriorityBlockingDrainingQueue(byte maxPriorityValue) {
        Preconditions.checkArgument(maxPriorityValue >= 0, "maxPriorityLevel must be a value between 0 and %s.", 127);
        this.queues = new SimpleDeque[maxPriorityValue + 1];
        this.firstIndex = 0;
        this.size = 0;
    }

    @Override
    protected void addInternal(T item) {
        byte p = item.getPriorityValue();
        Preconditions.checkArgument(p >= 0 && p < this.queues.length, "Item.getPriority() must be a value between 0 (inclusive) and %s (exclusive).", this.queues.length);
        this.getOrCreateQueue(p).addLast(item);
        ++this.size;
        if (this.firstIndex > p) {
            this.firstIndex = p;
        }
    }

    @Override
    protected int sizeInternal() {
        return this.size;
    }

    @Override
    protected T peekInternal() {
        if (this.size == 0) {
            return null;
        }
        int fi = this.getFirstIndex();
        assert (fi >= 0) : "size !=0 but firstIndex < 0";
        return (T)((Item)this.getQueue(fi).peekFirst());
    }

    @Override
    protected Queue<T> fetch(int maxCount) {
        if (this.size == 0) {
            return new ArrayDeque(0);
        }
        int fi = this.getFirstIndex();
        assert (fi >= 0) : "size !=0 but firstIndex < 0";
        SimpleDeque<T> q = this.getQueue(fi);
        Queue<T> result = q.pollFirst(maxCount);
        this.size -= result.size();
        return result;
    }

    private int getFirstIndex() {
        while (this.firstIndex < this.queues.length) {
            SimpleDeque<T> q = this.getQueue(this.firstIndex);
            if (q != null && !q.isEmpty()) {
                return this.firstIndex;
            }
            ++this.firstIndex;
        }
        assert (this.size > 0);
        this.firstIndex = 0;
        return -1;
    }

    private SimpleDeque<T> getQueue(int index) {
        return this.queues[index];
    }

    private SimpleDeque<T> getOrCreateQueue(int index) {
        SimpleDeque q = this.queues[index];
        if (q == null) {
            this.queues[index] = q = new SimpleDeque();
        }
        return q;
    }

    public static interface Item {
        public byte getPriorityValue();
    }
}

