/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink;

import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.connectors.flink.PravegaConfig;
import io.pravega.connectors.flink.util.StreamWithBoundaries;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractReaderBuilder<B extends AbstractReaderBuilder>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<StreamSpec> streams = new ArrayList<StreamSpec>(1);
    private PravegaConfig pravegaConfig = PravegaConfig.fromDefaults();
    private boolean enableMetrics = true;

    protected AbstractReaderBuilder() {
    }

    public B withPravegaConfig(PravegaConfig pravegaConfig) {
        this.pravegaConfig = pravegaConfig;
        return this.builder();
    }

    public B forStream(String streamSpec, StreamCut startStreamCut) {
        return this.forStream(streamSpec, startStreamCut, StreamCut.UNBOUNDED);
    }

    public B forStream(String streamSpec, StreamCut startStreamCut, StreamCut endStreamCut) {
        this.streams.add(StreamSpec.of(streamSpec, startStreamCut, endStreamCut));
        return this.builder();
    }

    public B forStream(String streamSpec) {
        return this.forStream(streamSpec, StreamCut.UNBOUNDED);
    }

    public B forStream(Stream stream, StreamCut startStreamCut) {
        return this.forStream(stream, startStreamCut, StreamCut.UNBOUNDED);
    }

    public B forStream(Stream stream, StreamCut startStreamCut, StreamCut endStreamCut) {
        this.streams.add(StreamSpec.of(stream, startStreamCut, endStreamCut));
        return this.builder();
    }

    public B forStream(Stream stream) {
        return this.forStream(stream, StreamCut.UNBOUNDED);
    }

    public PravegaConfig getPravegaConfig() {
        Preconditions.checkState((this.pravegaConfig != null ? 1 : 0) != 0, (Object)"A Pravega configuration must be supplied.");
        return this.pravegaConfig;
    }

    protected List<StreamWithBoundaries> resolveStreams() {
        Preconditions.checkState((!this.streams.isEmpty() ? 1 : 0) != 0, (Object)"At least one stream must be supplied.");
        PravegaConfig pravegaConfig = this.getPravegaConfig();
        return this.streams.stream().map(s2 -> StreamWithBoundaries.of(pravegaConfig.resolve(((StreamSpec)s2).streamSpec), ((StreamSpec)s2).from, ((StreamSpec)s2).to)).collect(Collectors.toList());
    }

    public B enableMetrics(boolean enable) {
        this.enableMetrics = enable;
        return this.builder();
    }

    public boolean isMetricsEnabled() {
        return this.enableMetrics;
    }

    protected abstract B builder();

    private static class StreamSpec
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String streamSpec;
        private final StreamCut from;
        private final StreamCut to;

        public static StreamSpec of(String streamSpec, StreamCut from, StreamCut to) {
            Preconditions.checkNotNull((Object)streamSpec, (String)"streamSpec");
            Preconditions.checkNotNull((Object)streamSpec, (String)"from");
            Preconditions.checkNotNull((Object)streamSpec, (String)"to");
            return new StreamSpec(streamSpec, from, to);
        }

        public static StreamSpec of(Stream stream, StreamCut from, StreamCut to) {
            Preconditions.checkNotNull((Object)stream, (String)"stream");
            Preconditions.checkNotNull((Object)stream, (String)"from");
            Preconditions.checkNotNull((Object)stream, (String)"to");
            return new StreamSpec(stream.getScopedName(), from, to);
        }

        public StreamSpec(String streamSpec, StreamCut from, StreamCut to) {
            this.streamSpec = streamSpec;
            this.from = from;
            this.to = to;
        }

        public String getStreamSpec() {
            return this.streamSpec;
        }

        public StreamCut getFrom() {
            return this.from;
        }

        public StreamCut getTo() {
            return this.to;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StreamSpec)) {
                return false;
            }
            StreamSpec other = (StreamSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$streamSpec = this.getStreamSpec();
            String other$streamSpec = other.getStreamSpec();
            if (this$streamSpec == null ? other$streamSpec != null : !this$streamSpec.equals(other$streamSpec)) {
                return false;
            }
            StreamCut this$from = this.getFrom();
            StreamCut other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            StreamCut this$to = this.getTo();
            StreamCut other$to = other.getTo();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StreamSpec;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $streamSpec = this.getStreamSpec();
            result = result * 59 + ($streamSpec == null ? 43 : $streamSpec.hashCode());
            StreamCut $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            StreamCut $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractReaderBuilder.StreamSpec(streamSpec=" + this.getStreamSpec() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }
}

