/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink;

import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.connectors.flink.AbstractReaderBuilder;
import io.pravega.connectors.flink.FlinkPravegaReader;
import io.pravega.connectors.flink.util.FlinkPravegaUtils;
import io.pravega.connectors.flink.watermark.AssignerWithTimeWindows;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

@Internal
public abstract class AbstractStreamingReaderBuilder<T, B extends AbstractStreamingReaderBuilder>
extends AbstractReaderBuilder<B> {
    private static final Time DEFAULT_EVENT_READ_TIMEOUT = Time.seconds((long)1L);
    private static final Time DEFAULT_CHECKPOINT_INITIATE_TIMEOUT = Time.seconds((long)5L);
    private static final int DEFAULT_MAX_OUTSTANDING_CHECKPOINT_REQUEST = 3;
    public String uid;
    public String readerGroupScope;
    public String readerGroupName;
    public Time readerGroupRefreshTime;
    public Time checkpointInitiateTimeout = DEFAULT_CHECKPOINT_INITIATE_TIMEOUT;
    public Time eventReadTimeout = DEFAULT_EVENT_READ_TIMEOUT;
    public int maxOutstandingCheckpointRequest = 3;

    protected AbstractStreamingReaderBuilder() {
    }

    public B uid(String uid) {
        this.uid = uid;
        return (B)((AbstractStreamingReaderBuilder)this.builder());
    }

    public B withReaderGroupScope(String scope) {
        this.readerGroupScope = (String)Preconditions.checkNotNull((Object)scope);
        return (B)((AbstractStreamingReaderBuilder)this.builder());
    }

    public B withReaderGroupName(String readerGroupName) {
        this.readerGroupName = (String)Preconditions.checkNotNull((Object)readerGroupName);
        return (B)((AbstractStreamingReaderBuilder)this.builder());
    }

    public B withReaderGroupRefreshTime(Time groupRefreshTime) {
        this.readerGroupRefreshTime = groupRefreshTime;
        return (B)((AbstractStreamingReaderBuilder)this.builder());
    }

    public B withCheckpointInitiateTimeout(Time checkpointInitiateTimeout) {
        Preconditions.checkArgument((checkpointInitiateTimeout.getSize() > 0L ? 1 : 0) != 0, (Object)"timeout must be > 0");
        this.checkpointInitiateTimeout = checkpointInitiateTimeout;
        return (B)((AbstractStreamingReaderBuilder)this.builder());
    }

    public B withEventReadTimeout(Time eventReadTimeout) {
        Preconditions.checkArgument((eventReadTimeout.getSize() > 0L ? 1 : 0) != 0, (Object)"timeout must be > 0");
        this.eventReadTimeout = eventReadTimeout;
        return (B)((AbstractStreamingReaderBuilder)this.builder());
    }

    public B withMaxOutstandingCheckpointRequest(int maxOutstandingCheckpointRequest) {
        this.maxOutstandingCheckpointRequest = maxOutstandingCheckpointRequest;
        return (B)((AbstractStreamingReaderBuilder)this.builder());
    }

    protected abstract DeserializationSchema<T> getDeserializationSchema();

    protected abstract SerializedValue<AssignerWithTimeWindows<T>> getAssignerWithTimeWindows();

    protected FlinkPravegaReader<T> buildSourceFunction() {
        ReaderGroupInfo readerGroupInfo = this.buildReaderGroupInfo();
        return new FlinkPravegaReader<T>(Optional.ofNullable(this.uid).orElseGet(this::generateUid), this.getPravegaConfig().getClientConfig(), readerGroupInfo.getReaderGroupConfig(), readerGroupInfo.getReaderGroupScope(), readerGroupInfo.getReaderGroupName(), this.getDeserializationSchema(), this.getAssignerWithTimeWindows(), this.eventReadTimeout, this.checkpointInitiateTimeout, this.isMetricsEnabled());
    }

    public ReaderGroupInfo buildReaderGroupInfo() {
        ReaderGroupConfig.ReaderGroupConfigBuilder rgConfigBuilder = ReaderGroupConfig.builder().maxOutstandingCheckpointRequest(this.maxOutstandingCheckpointRequest).disableAutomaticCheckpoints();
        if (this.readerGroupRefreshTime != null) {
            rgConfigBuilder.groupRefreshTimeMillis(this.readerGroupRefreshTime.toMilliseconds());
        }
        this.resolveStreams().forEach(s2 -> rgConfigBuilder.stream(s2.getStream(), s2.getFrom(), s2.getTo()));
        ReaderGroupConfig rgConfig = rgConfigBuilder.build();
        String rgScope = Optional.ofNullable(this.readerGroupScope).orElseGet(() -> {
            Preconditions.checkState((this.getPravegaConfig().getDefaultScope() != null ? 1 : 0) != 0, (Object)"A reader group scope or default scope must be configured");
            return this.getPravegaConfig().getDefaultScope();
        });
        String rgName = Optional.ofNullable(this.readerGroupName).orElseGet(FlinkPravegaUtils::generateRandomReaderGroupName);
        return new ReaderGroupInfo(rgConfig, rgScope, rgName);
    }

    private boolean isReaderGroupNameAutoGenerated(String readerGroupName) {
        String pattern = "^flink\\w{20}$";
        Matcher matcher = Pattern.compile(pattern).matcher(readerGroupName);
        return matcher.matches();
    }

    public String generateUid() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.readerGroupScope).append('\n');
        if (this.readerGroupName != null && !this.isReaderGroupNameAutoGenerated(this.readerGroupName)) {
            sb.append(this.readerGroupName).append('\n');
        }
        this.resolveStreams().forEach(s2 -> sb.append(s2.getStream().getScopedName()).append('\n'));
        return Integer.toString(sb.toString().hashCode());
    }

    public static class ReaderGroupInfo {
        private final ReaderGroupConfig readerGroupConfig;
        private final String readerGroupScope;
        private final String readerGroupName;

        public ReaderGroupInfo(ReaderGroupConfig rgConfig, String rgScope, String rgName) {
            this.readerGroupConfig = rgConfig;
            this.readerGroupScope = rgScope;
            this.readerGroupName = rgName;
        }

        public ReaderGroupConfig getReaderGroupConfig() {
            return this.readerGroupConfig;
        }

        public String getReaderGroupScope() {
            return this.readerGroupScope;
        }

        public String getReaderGroupName() {
            return this.readerGroupName;
        }
    }
}

