/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink;

import io.pravega.connectors.flink.AbstractWriterBuilder;
import io.pravega.connectors.flink.FlinkPravegaWriter;
import io.pravega.connectors.flink.PravegaEventRouter;
import io.pravega.connectors.flink.PravegaWriterMode;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractStreamingWriterBuilder<T, B extends AbstractStreamingWriterBuilder>
extends AbstractWriterBuilder<B> {
    protected static final long DEFAULT_TXN_LEASE_RENEWAL_PERIOD_MILLIS = 120000L;
    public PravegaWriterMode writerMode = PravegaWriterMode.ATLEAST_ONCE;
    public boolean enableWatermark = false;
    public Time txnLeaseRenewalPeriod = Time.milliseconds((long)120000L);

    protected AbstractStreamingWriterBuilder() {
    }

    public B withWriterMode(PravegaWriterMode writerMode) {
        this.writerMode = writerMode;
        return (B)((AbstractStreamingWriterBuilder)this.builder());
    }

    public B enableWatermark(boolean enableWatermark) {
        this.enableWatermark = enableWatermark;
        return (B)((AbstractStreamingWriterBuilder)this.builder());
    }

    public B withTxnLeaseRenewalPeriod(Time period) {
        Preconditions.checkArgument((period.getSize() > 0L ? 1 : 0) != 0, (Object)"The timeout must be a positive value.");
        this.txnLeaseRenewalPeriod = period;
        return (B)((AbstractStreamingWriterBuilder)this.builder());
    }

    protected FlinkPravegaWriter<T> createSinkFunction(SerializationSchema<T> serializationSchema, PravegaEventRouter<T> eventRouter) {
        Preconditions.checkNotNull(serializationSchema, (String)"serializationSchema");
        return new FlinkPravegaWriter<T>(this.getPravegaConfig().getClientConfig(), this.resolveStream(), serializationSchema, eventRouter, this.writerMode, this.txnLeaseRenewalPeriod.toMilliseconds(), this.enableWatermark, this.isMetricsEnabled());
    }
}

