/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink;

import io.pravega.client.stream.Stream;
import io.pravega.connectors.flink.PravegaConfig;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractWriterBuilder<B extends AbstractWriterBuilder>
implements Serializable {
    private PravegaConfig pravegaConfig = PravegaConfig.fromDefaults();
    private StreamSpec stream;
    private boolean enableMetrics = true;

    public B withPravegaConfig(PravegaConfig pravegaConfig) {
        this.pravegaConfig = pravegaConfig;
        return this.builder();
    }

    public B forStream(String streamSpec) {
        this.stream = StreamSpec.of(streamSpec);
        return this.builder();
    }

    public B forStream(Stream stream) {
        this.stream = StreamSpec.of(stream);
        return this.builder();
    }

    public PravegaConfig getPravegaConfig() {
        Preconditions.checkState((this.pravegaConfig != null ? 1 : 0) != 0, (Object)"A Pravega configuration must be supplied.");
        return this.pravegaConfig;
    }

    public Stream resolveStream() {
        Preconditions.checkState((this.stream != null ? 1 : 0) != 0, (Object)"A stream must be supplied.");
        PravegaConfig pravegaConfig = this.getPravegaConfig();
        return pravegaConfig.resolve(this.stream.streamSpec);
    }

    public B enableMetrics(boolean enable) {
        this.enableMetrics = enable;
        return this.builder();
    }

    public boolean isMetricsEnabled() {
        return this.enableMetrics;
    }

    protected abstract B builder();

    private static class StreamSpec
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String streamSpec;

        public static StreamSpec of(String streamSpec) {
            Preconditions.checkNotNull((Object)streamSpec, (String)"streamSpec");
            return new StreamSpec(streamSpec);
        }

        public static StreamSpec of(Stream stream) {
            Preconditions.checkNotNull((Object)stream, (String)"stream");
            return new StreamSpec(stream.getScopedName());
        }

        public StreamSpec(String streamSpec) {
            this.streamSpec = streamSpec;
        }

        public String getStreamSpec() {
            return this.streamSpec;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StreamSpec)) {
                return false;
            }
            StreamSpec other = (StreamSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$streamSpec = this.getStreamSpec();
            String other$streamSpec = other.getStreamSpec();
            return !(this$streamSpec == null ? other$streamSpec != null : !this$streamSpec.equals(other$streamSpec));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StreamSpec;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $streamSpec = this.getStreamSpec();
            result = result * 59 + ($streamSpec == null ? 43 : $streamSpec.hashCode());
            return result;
        }

        public String toString() {
            return "AbstractWriterBuilder.StreamSpec(streamSpec=" + this.getStreamSpec() + ")";
        }
    }
}

