/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink;

import io.pravega.client.stream.Checkpoint;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.SimpleVersionedSerializer;

class CheckpointSerializer
implements SimpleVersionedSerializer<Checkpoint> {
    private static final int VERSION = 2;

    CheckpointSerializer() {
    }

    public int getVersion() {
        return 2;
    }

    public byte[] serialize(Checkpoint checkpoint) throws IOException {
        ByteBuffer buf = checkpoint.toBytes();
        byte[] b = new byte[buf.remaining()];
        buf.get(b);
        return b;
    }

    public Checkpoint deserialize(int version, byte[] bytes) throws IOException {
        if (version != 2) {
            throw new IOException("Invalid format version for serialized Pravega Checkpoint: " + version);
        }
        return Checkpoint.fromBytes(ByteBuffer.wrap(bytes));
    }
}

