/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink;

import io.pravega.client.ClientConfig;
import io.pravega.client.stream.Stream;
import io.pravega.shared.security.auth.Credentials;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.util.Preconditions;

public class PravegaConfig
implements Serializable {
    static final PravegaParameter CONTROLLER_PARAM = new PravegaParameter("controller", "pravega.controller.uri", "PRAVEGA_CONTROLLER_URI");
    static final PravegaParameter SCOPE_PARAM = new PravegaParameter("scope", "pravega.scope", "PRAVEGA_SCOPE");
    static final PravegaParameter SCHEMA_REGISTRY_PARAM = new PravegaParameter("schema-registry", "pravega.schema-registry.uri", "PRAVEGA_SCHEMA_REGISTRY_URI");
    private static final long serialVersionUID = 1L;
    private URI controllerURI;
    private URI schemaRegistryURI;
    private String defaultScope;
    private Credentials credentials;
    private boolean validateHostname = true;
    private String trustStore;

    PravegaConfig(Properties properties, Map<String, String> env, ParameterTool params) {
        this.controllerURI = CONTROLLER_PARAM.resolve(params, properties, env).map(URI::create).orElse(null);
        this.defaultScope = SCOPE_PARAM.resolve(params, properties, env).orElse(null);
        this.schemaRegistryURI = SCHEMA_REGISTRY_PARAM.resolve(params, properties, env).map(URI::create).orElse(null);
    }

    public static PravegaConfig fromDefaults() {
        return new PravegaConfig(System.getProperties(), System.getenv(), ParameterTool.fromMap(Collections.emptyMap()));
    }

    public static PravegaConfig fromParams(ParameterTool params) {
        return new PravegaConfig(System.getProperties(), System.getenv(), params);
    }

    public ClientConfig getClientConfig() {
        ClientConfig.ClientConfigBuilder builder = ClientConfig.builder().validateHostName(this.validateHostname);
        if (this.controllerURI != null) {
            builder.controllerURI(this.controllerURI);
        }
        if (this.credentials != null) {
            builder.credentials(this.credentials);
        }
        if (this.trustStore != null) {
            builder.trustStore(this.trustStore);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PravegaConfig that = (PravegaConfig)o;
        return this.validateHostname == that.validateHostname && this.controllerURI.equals(that.controllerURI) && this.defaultScope.equals(that.defaultScope) && Objects.equals(this.schemaRegistryURI, that.schemaRegistryURI) && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.trustStore, that.trustStore);
    }

    public int hashCode() {
        return Objects.hash(this.controllerURI, this.schemaRegistryURI, this.defaultScope, this.credentials, this.validateHostname, this.trustStore);
    }

    public Stream resolve(String streamSpec) {
        Preconditions.checkNotNull((Object)streamSpec, (String)"streamSpec");
        String[] split = streamSpec.split("/", 2);
        if (split.length == 1) {
            Preconditions.checkState((this.defaultScope != null ? 1 : 0) != 0, (Object)"The default scope is not configured.");
            return Stream.of(this.defaultScope, split[0]);
        }
        assert (split.length == 2);
        return Stream.of(split[0], split[1]);
    }

    public PravegaConfig withControllerURI(URI controllerURI) {
        this.controllerURI = controllerURI;
        return this;
    }

    public PravegaConfig withSchemaRegistryURI(URI schemaRegistryURI) {
        this.schemaRegistryURI = schemaRegistryURI;
        return this;
    }

    public PravegaConfig withTrustStore(String trustStore) {
        this.trustStore = trustStore;
        return this;
    }

    public PravegaConfig withDefaultScope(String scope) {
        if (this.defaultScope == null) {
            this.defaultScope = scope;
        }
        return this;
    }

    public PravegaConfig withScope(String scope) {
        this.defaultScope = scope;
        return this;
    }

    @Nullable
    public String getDefaultScope() {
        return this.defaultScope;
    }

    @Nullable
    public URI getSchemaRegistryUri() {
        return this.schemaRegistryURI;
    }

    public PravegaConfig withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    public Credentials getCredentials() {
        return this.credentials;
    }

    public PravegaConfig withHostnameValidation(boolean validateHostname) {
        this.validateHostname = validateHostname;
        return this;
    }

    static class PravegaParameter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String parameterName;
        private final String propertyName;
        private final String variableName;

        public Optional<String> resolve(ParameterTool parameters, Properties properties, Map<String, String> variables) {
            if (parameters != null && parameters.has(this.parameterName)) {
                return Optional.of(parameters.get(this.parameterName));
            }
            if (properties != null && properties.containsKey(this.propertyName)) {
                return Optional.of(properties.getProperty(this.propertyName));
            }
            if (variables != null && variables.containsKey(this.variableName)) {
                return Optional.of(variables.get(this.variableName));
            }
            return Optional.empty();
        }

        public PravegaParameter(String parameterName, String propertyName, String variableName) {
            this.parameterName = parameterName;
            this.propertyName = propertyName;
            this.variableName = variableName;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PravegaParameter)) {
                return false;
            }
            PravegaParameter other = (PravegaParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$parameterName = this.getParameterName();
            String other$parameterName = other.getParameterName();
            if (this$parameterName == null ? other$parameterName != null : !this$parameterName.equals(other$parameterName)) {
                return false;
            }
            String this$propertyName = this.getPropertyName();
            String other$propertyName = other.getPropertyName();
            if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
                return false;
            }
            String this$variableName = this.getVariableName();
            String other$variableName = other.getVariableName();
            return !(this$variableName == null ? other$variableName != null : !this$variableName.equals(other$variableName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PravegaParameter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $parameterName = this.getParameterName();
            result = result * 59 + ($parameterName == null ? 43 : $parameterName.hashCode());
            String $propertyName = this.getPropertyName();
            result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
            String $variableName = this.getVariableName();
            result = result * 59 + ($variableName == null ? 43 : $variableName.hashCode());
            return result;
        }

        public String toString() {
            return "PravegaConfig.PravegaParameter(parameterName=" + this.getParameterName() + ", propertyName=" + this.getPropertyName() + ", variableName=" + this.getVariableName() + ")";
        }
    }
}

