/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink;

import io.pravega.client.batch.SegmentRange;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.util.Preconditions;

public class PravegaInputSplit
implements InputSplit {
    private final int splitId;
    private final SegmentRange segmentRange;

    public PravegaInputSplit(int splitId, SegmentRange segmentRange) {
        Preconditions.checkArgument((splitId >= 0 ? 1 : 0) != 0, (Object)"The splitId is not recognizable.");
        Preconditions.checkNotNull((Object)segmentRange, (String)"segmentRange");
        this.splitId = splitId;
        this.segmentRange = segmentRange;
    }

    public int getSplitNumber() {
        return this.splitId;
    }

    public SegmentRange getSegmentRange() {
        return this.segmentRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PravegaInputSplit)) {
            return false;
        }
        PravegaInputSplit that = (PravegaInputSplit)o;
        if (!this.getSegmentRange().equals(that.getSegmentRange())) {
            return false;
        }
        return this.splitId == that.splitId;
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = result * prime + this.splitId;
        result = result * prime + Long.hashCode(this.getSegmentRange().getSegmentId());
        result = result * prime + Long.hashCode(this.getSegmentRange().getStartOffset());
        result = result * prime + Long.hashCode(this.getSegmentRange().getEndOffset());
        String scope = this.getSegmentRange().getScope();
        String stream = this.getSegmentRange().getStreamName();
        result = result * prime + (scope == null ? 43 : scope.hashCode());
        result = result * prime + (stream == null ? 43 : stream.hashCode());
        return result;
    }

    public String toString() {
        return "PravegaInputSplit {splitId = " + this.splitId + ", segmentRange = " + this.segmentRange.toString() + "}";
    }
}

