/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink.serialization;

import io.pravega.client.stream.Serializer;
import io.pravega.connectors.flink.PravegaConfig;
import io.pravega.connectors.flink.util.SchemaRegistryUtils;
import io.pravega.schemaregistry.client.SchemaRegistryClient;
import io.pravega.schemaregistry.client.SchemaRegistryClientConfig;
import io.pravega.schemaregistry.client.SchemaRegistryClientFactory;
import io.pravega.schemaregistry.contract.data.SerializationFormat;
import io.pravega.schemaregistry.serializer.avro.schemas.AvroSchema;
import io.pravega.schemaregistry.serializer.json.schemas.JSONSchema;
import io.pravega.schemaregistry.serializer.shared.impl.SerializerConfig;
import io.pravega.schemaregistry.serializers.SerializerFactory;
import io.pravega.shaded.com.google.protobuf.DynamicMessage;
import io.pravega.shaded.org.apache.commons.lang3.NotImplementedException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeserializerFromSchemaRegistry<T>
implements Serializer<T>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DeserializerFromSchemaRegistry.class);
    private static final long serialVersionUID = 1L;
    private final PravegaConfig pravegaConfig;
    private final String group;
    private final Class<T> tClass;
    private transient Serializer<T> serializer;

    public DeserializerFromSchemaRegistry(PravegaConfig pravegaConfig, String group, Class<T> tClass) {
        Preconditions.checkNotNull((Object)pravegaConfig.getSchemaRegistryUri());
        this.pravegaConfig = pravegaConfig;
        this.group = group;
        this.tClass = tClass;
        this.serializer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        DeserializerFromSchemaRegistry deserializerFromSchemaRegistry = this;
        synchronized (deserializerFromSchemaRegistry) {
            SerializationFormat format;
            SchemaRegistryClientConfig schemaRegistryClientConfig = SchemaRegistryUtils.getSchemaRegistryClientConfig(this.pravegaConfig);
            try (SchemaRegistryClient schemaRegistryClient = SchemaRegistryClientFactory.withNamespace((String)this.pravegaConfig.getDefaultScope(), (SchemaRegistryClientConfig)schemaRegistryClientConfig);){
                format = schemaRegistryClient.getLatestSchemaVersion(this.group, null).getSchemaInfo().getSerializationFormat();
            }
            catch (Exception e) {
                log.error("Error while closing the schema registry client", (Throwable)e);
                throw new FlinkRuntimeException((Throwable)e);
            }
            SerializerConfig serializerConfig = SerializerConfig.builder().namespace(this.pravegaConfig.getDefaultScope()).groupId(this.group).registerSchema(false).registryConfig(schemaRegistryClientConfig).build();
            switch (format) {
                case Json: {
                    this.serializer = SerializerFactory.jsonDeserializer((SerializerConfig)serializerConfig, (JSONSchema)JSONSchema.of(this.tClass));
                    break;
                }
                case Avro: {
                    Preconditions.checkArgument((boolean)IndexedRecord.class.isAssignableFrom(this.tClass));
                    if (GenericRecord.class.isAssignableFrom(this.tClass)) {
                        this.serializer = SerializerFactory.avroGenericDeserializer((SerializerConfig)serializerConfig, null);
                        break;
                    }
                    this.serializer = SerializerFactory.avroDeserializer((SerializerConfig)serializerConfig, (AvroSchema)AvroSchema.of(this.tClass));
                    break;
                }
                case Protobuf: {
                    if (DynamicMessage.class.isAssignableFrom(this.tClass)) {
                        this.serializer = SerializerFactory.protobufGenericDeserializer((SerializerConfig)serializerConfig, null);
                        break;
                    }
                    throw new UnsupportedOperationException("Only support DynamicMessage in Protobuf");
                }
                default: {
                    throw new NotImplementedException("Not supporting serialization format");
                }
            }
        }
    }

    @Override
    public ByteBuffer serialize(T value) {
        throw new NotImplementedException("Not supporting serialize in Deserializer");
    }

    @Override
    public T deserialize(ByteBuffer serializedValue) {
        if (this.serializer == null) {
            this.initialize();
        }
        return this.serializer.deserialize(serializedValue);
    }
}

