/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink.serialization;

import io.pravega.client.stream.Serializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;

public class JsonSerializer<T>
implements Serializer<T>,
Serializable {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private Class<T> valueType;

    public JsonSerializer(Class<T> valueType) {
        this.valueType = valueType;
    }

    @Override
    public ByteBuffer serialize(T value) {
        byte[] bytes = new byte[]{};
        try {
            bytes = this.objectMapper.writeValueAsBytes(value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public T deserialize(ByteBuffer serializedValue) {
        ByteArrayInputStream bin = new ByteArrayInputStream(serializedValue.array(), serializedValue.position(), serializedValue.remaining());
        Object event = null;
        try {
            event = this.objectMapper.readValue((InputStream)bin, this.valueType);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return (T)event;
    }
}

