/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink.serialization;

import io.pravega.client.stream.EventRead;
import io.pravega.client.stream.Serializer;
import io.pravega.connectors.flink.serialization.WrappingSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Preconditions;

public class PravegaDeserializationSchema<T>
implements DeserializationSchema<T>,
WrappingSerializer<T> {
    private final TypeInformation<T> typeInfo;
    private final Serializer<T> serializer;

    public PravegaDeserializationSchema(Class<T> typeClass, Serializer<T> serializer) {
        Preconditions.checkNotNull(typeClass);
        PravegaDeserializationSchema.checkSerializer(serializer);
        this.serializer = serializer;
        try {
            this.typeInfo = TypeInformation.of(typeClass);
        }
        catch (InvalidTypesException e) {
            throw new IllegalArgumentException("Due to Java's type erasure, the generic type information cannot be properly inferred. Please pass a 'TypeHint' instead of a class to describe the type. For example, to describe 'Tuple2<String, String>' as a generic type, use 'new PravegaDeserializationSchema<>(new TypeHint<Tuple2<String, String>>(){}, serializer);'");
        }
    }

    public PravegaDeserializationSchema(TypeHint<T> typeHint, Serializer<T> serializer) {
        this(TypeInformation.of(typeHint), serializer);
    }

    public PravegaDeserializationSchema(TypeInformation<T> typeInfo, Serializer<T> serializer) {
        Preconditions.checkNotNull(typeInfo, (String)"typeInfo");
        PravegaDeserializationSchema.checkSerializer(serializer);
        this.typeInfo = typeInfo;
        this.serializer = serializer;
    }

    public T deserialize(byte[] message) throws IOException {
        ByteBuffer msg = ByteBuffer.wrap(message);
        return this.serializer.deserialize(msg);
    }

    public boolean isEndOfStream(T nextElement) {
        return false;
    }

    public TypeInformation<T> getProducedType() {
        return this.typeInfo;
    }

    @Override
    public Serializer<T> getWrappedSerializer() {
        return this.serializer;
    }

    public T extractEvent(EventRead<T> eventRead) {
        return eventRead.getEvent();
    }

    private static void checkSerializer(Serializer<?> serializer) {
        Preconditions.checkNotNull(serializer, (String)"serializer");
        Preconditions.checkArgument((boolean)(serializer instanceof Serializable), (Object)"The serializer class must be serializable (java.io.Serializable).");
    }
}

