/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink.serialization;

import io.pravega.client.stream.Serializer;
import io.pravega.connectors.flink.serialization.WrappingSerializer;
import java.nio.ByteBuffer;
import org.apache.flink.api.common.serialization.SerializationSchema;

public class PravegaSerializationSchema<T>
implements SerializationSchema<T>,
WrappingSerializer<T> {
    private final Serializer<T> serializer;

    public PravegaSerializationSchema(Serializer<T> serializer) {
        this.serializer = serializer;
    }

    public byte[] serialize(T element) {
        ByteBuffer buf = this.serializer.serialize(element);
        if (buf.hasArray() && buf.arrayOffset() == 0 && buf.position() == 0 && buf.limit() == buf.capacity()) {
            return buf.array();
        }
        byte[] bytes = new byte[buf.remaining()];
        buf.get(bytes);
        return bytes;
    }

    @Override
    public Serializer<T> getWrappedSerializer() {
        return this.serializer;
    }
}

