/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink.table.descriptors;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator;
import org.apache.flink.table.descriptors.DescriptorProperties;

@Deprecated
public class PravegaValidator
extends ConnectorDescriptorValidator {
    public void validate(DescriptorProperties properties) {
        super.validate(properties);
        properties.validateValue("connector.type", "pravega", false);
        this.validateConnectionConfig(properties);
        if (properties.containsKey("connector.reader")) {
            this.validateReaderConfigurations(properties);
        }
        if (properties.containsKey("connector.writer")) {
            this.validateWriterConfigurations(properties);
        }
    }

    private void validateConnectionConfig(DescriptorProperties properties) {
        properties.validateString("connector.connection-config.controller-uri", false, 1, Integer.MAX_VALUE);
    }

    private void validateReaderConfigurations(DescriptorProperties properties) {
        HashMap<String, Consumer<String>> streamPropertyValidators = new HashMap<String, Consumer<String>>();
        streamPropertyValidators.put("scope", prefix -> properties.validateString(prefix, true, 1));
        streamPropertyValidators.put("stream", prefix -> properties.validateString(prefix, false, 0));
        streamPropertyValidators.put("start-streamcut", prefix -> properties.validateString(prefix, true, 1));
        streamPropertyValidators.put("end-streamcut", prefix -> properties.validateString(prefix, true, 1));
        properties.validateFixedIndexedProperties("connector.reader.stream-info", true, streamPropertyValidators);
        Optional readerGroupScope = properties.getOptionalString("connector.reader.reader-group.scope");
        Optional connConfigDefaultScope = properties.getOptionalString("connector.connection-config.default-scope");
        if (!readerGroupScope.isPresent() && !connConfigDefaultScope.isPresent()) {
            throw new ValidationException("Must supply either connector.reader.reader-group.scope or connector.connection-config.default-scope");
        }
    }

    private void validateWriterConfigurations(DescriptorProperties properties) {
        properties.validateString("connector.writer.scope", true, 1, Integer.MAX_VALUE);
        properties.validateString("connector.writer.stream", false, 1, Integer.MAX_VALUE);
        properties.validateString("connector.writer.routingkey-field-name", false, 1, Integer.MAX_VALUE);
        Optional scope = properties.getOptionalString("connector.writer.scope");
        Optional connConfigDefaultScope = properties.getOptionalString("connector.connection-config.default-scope");
        if (!scope.isPresent() && !connConfigDefaultScope.isPresent()) {
            throw new ValidationException("Must supply either connector.writer.scope or connector.connection-config.default-scope");
        }
        HashMap<String, Consumer> writerModeValidators = new HashMap<String, Consumer>();
        writerModeValidators.put("exactly_once", properties.noValidation());
        writerModeValidators.put("atleast_once", properties.noValidation());
        properties.validateEnum("connector.writer.mode", true, writerModeValidators);
    }
}

