/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink.util;

import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.connectors.flink.PravegaConfig;
import io.pravega.connectors.flink.PravegaWriterMode;
import io.pravega.connectors.flink.util.StreamWithBoundaries;
import io.pravega.connectors.flink.watermark.AssignerWithTimeWindows;
import io.pravega.shared.security.auth.Credentials;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.types.Row;
import org.apache.flink.util.InstantiationUtil;

@Deprecated
public final class ConnectorConfigurations {
    private static final String AUTH_PARAM_LOAD_DYNAMIC = "pravega.client.auth.loadDynamic";
    private static final String AUTH_PARAM_LOAD_DYNAMIC_ENV = "pravega_client_auth_loadDynamic";
    private Optional<Boolean> metrics;
    private String controllerUri;
    private Optional<String> defaultScope;
    private Optional<String> authType;
    private Optional<String> authToken;
    private Optional<Boolean> validateHostName;
    private Optional<String> trustStore;
    private Optional<String> uid;
    private Optional<String> rgScope;
    private Optional<String> rgName;
    private Optional<Long> refreshInterval;
    private Optional<Long> eventReadTimeoutInterval;
    private Optional<Long> checkpointInitiateTimeoutInterval;
    private List<StreamWithBoundaries> readerStreams = new ArrayList<StreamWithBoundaries>();
    private Optional<AssignerWithTimeWindows<Row>> assignerWithTimeWindows;
    private Stream writerStream;
    private Optional<PravegaWriterMode> writerMode;
    private Optional<Long> txnLeaseRenewalInterval;
    private Optional<Boolean> watermark;
    private String routingKey;
    private PravegaConfig pravegaConfig;

    public void parseConfigurations(DescriptorProperties descriptorProperties, ConfigurationType configurationType) {
        this.metrics = descriptorProperties.getOptionalBoolean("connector.metrics");
        this.controllerUri = descriptorProperties.getString("connector.connection-config.controller-uri");
        this.defaultScope = descriptorProperties.getOptionalString("connector.connection-config.default-scope");
        this.authType = descriptorProperties.getOptionalString("connector.connection-config.security.auth-type");
        this.authToken = descriptorProperties.getOptionalString("connector.connection-config.security.auth-token");
        this.validateHostName = descriptorProperties.getOptionalBoolean("connector.connection-config.security.validate-hostname");
        this.trustStore = descriptorProperties.getOptionalString("connector.connection-config.security.trust-store");
        this.createPravegaConfig();
        if (configurationType == ConfigurationType.READER) {
            this.populateReaderConfig(descriptorProperties);
        }
        if (configurationType == ConfigurationType.WRITER) {
            this.populateWriterConfig(descriptorProperties);
        }
    }

    private void populateReaderConfig(DescriptorProperties descriptorProperties) {
        this.uid = descriptorProperties.getOptionalString("connector.reader.reader-group.uid");
        this.rgScope = descriptorProperties.getOptionalString("connector.reader.reader-group.scope");
        this.rgName = descriptorProperties.getOptionalString("connector.reader.reader-group.name");
        this.refreshInterval = descriptorProperties.getOptionalLong("connector.reader.reader-group.refresh-interval");
        this.eventReadTimeoutInterval = descriptorProperties.getOptionalLong("connector.reader.reader-group.event-read-timeout-interval");
        this.checkpointInitiateTimeoutInterval = descriptorProperties.getOptionalLong("connector.reader.reader-group.checkpoint-initiate-timeout-interval");
        Optional assignerClass = descriptorProperties.getOptionalClass("connector.reader.user.timestamp-assigner", AssignerWithTimeWindows.class);
        this.assignerWithTimeWindows = assignerClass.map(assignerWithTimeWindowsClass -> (AssignerWithTimeWindows)InstantiationUtil.instantiate((Class)assignerWithTimeWindowsClass));
        if (!this.defaultScope.isPresent() && !this.rgScope.isPresent()) {
            throw new ValidationException("Must supply either connector.reader.reader-group.scope or connector.connection-config.default-scope");
        }
        List streamPropsList = descriptorProperties.getVariableIndexedProperties("connector.reader.stream-info", Collections.singletonList("stream"));
        if (streamPropsList.isEmpty()) {
            throw new ValidationException("connector.reader.stream-info cannot be empty");
        }
        int index = 0;
        for (Map propsMap : streamPropsList) {
            String scopeName;
            if (!propsMap.containsKey("scope") && !this.defaultScope.isPresent()) {
                throw new ValidationException("Must supply either connector.reader.stream-info." + index + "." + "scope" + " or " + "connector.connection-config.default-scope");
            }
            String string = scopeName = propsMap.containsKey("scope") ? descriptorProperties.getString((String)propsMap.get("scope")) : this.defaultScope.get();
            if (!propsMap.containsKey("stream")) {
                throw new ValidationException("connector.reader.stream-info." + index + "." + "stream" + " cannot be empty");
            }
            String streamName = descriptorProperties.getString((String)propsMap.get("stream"));
            String startCut = StreamCut.UNBOUNDED.asText();
            if (propsMap.containsKey("start-streamcut")) {
                startCut = descriptorProperties.getString((String)propsMap.get("start-streamcut"));
            }
            String endCut = StreamCut.UNBOUNDED.asText();
            if (propsMap.containsKey("end-streamcut")) {
                endCut = descriptorProperties.getString((String)propsMap.get("end-streamcut"));
            }
            Stream stream = Stream.of(scopeName, streamName);
            this.readerStreams.add(new StreamWithBoundaries(stream, StreamCut.from(startCut), StreamCut.from(endCut)));
            ++index;
        }
    }

    private void populateWriterConfig(DescriptorProperties descriptorProperties) {
        Optional streamScope = descriptorProperties.getOptionalString("connector.writer.scope");
        if (!this.defaultScope.isPresent() && !streamScope.isPresent()) {
            throw new ValidationException("Must supply either connector.writer.scope or connector.connection-config.default-scope");
        }
        String scopeVal = streamScope.orElseGet(() -> this.defaultScope.get());
        if (!descriptorProperties.containsKey("connector.writer.stream")) {
            throw new ValidationException("Missing connector.writer.stream configuration.");
        }
        String streamName = descriptorProperties.getString("connector.writer.stream");
        this.writerStream = Stream.of(scopeVal, streamName);
        this.txnLeaseRenewalInterval = descriptorProperties.getOptionalLong("connector.writer.txn-lease-renewal-interval");
        if (!descriptorProperties.containsKey("connector.writer.routingkey-field-name")) {
            throw new ValidationException("Missing connector.writer.routingkey-field-name configuration.");
        }
        this.watermark = descriptorProperties.getOptionalBoolean("connector.writer.enable-watermark");
        this.routingKey = descriptorProperties.getString("connector.writer.routingkey-field-name");
        Optional optionalMode = descriptorProperties.getOptionalString("connector.writer.mode");
        if (optionalMode.isPresent()) {
            String mode = (String)optionalMode.get();
            if (mode.equals("atleast_once")) {
                this.writerMode = Optional.of(PravegaWriterMode.ATLEAST_ONCE);
            } else if (mode.equals("exactly_once")) {
                this.writerMode = Optional.of(PravegaWriterMode.EXACTLY_ONCE);
            } else {
                throw new ValidationException("Invalid writer mode " + mode + " passed. Supported values: (" + "atleast_once" + " or " + "exactly_once" + ")");
            }
        }
    }

    private void createPravegaConfig() {
        this.pravegaConfig = PravegaConfig.fromDefaults().withControllerURI(URI.create(this.controllerUri));
        this.defaultScope.ifPresent(s2 -> this.pravegaConfig.withDefaultScope((String)s2));
        if (this.authType.isPresent() && this.authToken.isPresent() && !this.isCredentialsLoadDynamic()) {
            this.pravegaConfig.withCredentials(new SimpleCredentials(this.authType.get(), this.authToken.get()));
        }
        this.validateHostName.ifPresent(hv -> {
            this.pravegaConfig = this.pravegaConfig.withHostnameValidation((boolean)hv);
        });
        this.trustStore.ifPresent(ts -> {
            this.pravegaConfig = this.pravegaConfig.withTrustStore((String)ts);
        });
    }

    private boolean isCredentialsLoadDynamic() {
        return System.getProperties().contains(AUTH_PARAM_LOAD_DYNAMIC) && Boolean.parseBoolean(System.getProperty(AUTH_PARAM_LOAD_DYNAMIC)) || System.getenv().containsKey(AUTH_PARAM_LOAD_DYNAMIC_ENV) && Boolean.parseBoolean(System.getenv(AUTH_PARAM_LOAD_DYNAMIC_ENV));
    }

    public Optional<Boolean> getMetrics() {
        return this.metrics;
    }

    public String getControllerUri() {
        return this.controllerUri;
    }

    public Optional<String> getDefaultScope() {
        return this.defaultScope;
    }

    public Optional<String> getAuthType() {
        return this.authType;
    }

    public Optional<String> getAuthToken() {
        return this.authToken;
    }

    public Optional<Boolean> getValidateHostName() {
        return this.validateHostName;
    }

    public Optional<String> getTrustStore() {
        return this.trustStore;
    }

    public Optional<String> getUid() {
        return this.uid;
    }

    public Optional<String> getRgScope() {
        return this.rgScope;
    }

    public Optional<String> getRgName() {
        return this.rgName;
    }

    public Optional<Long> getRefreshInterval() {
        return this.refreshInterval;
    }

    public Optional<Long> getEventReadTimeoutInterval() {
        return this.eventReadTimeoutInterval;
    }

    public Optional<Long> getCheckpointInitiateTimeoutInterval() {
        return this.checkpointInitiateTimeoutInterval;
    }

    public List<StreamWithBoundaries> getReaderStreams() {
        return this.readerStreams;
    }

    public Optional<AssignerWithTimeWindows<Row>> getAssignerWithTimeWindows() {
        return this.assignerWithTimeWindows;
    }

    public Stream getWriterStream() {
        return this.writerStream;
    }

    public Optional<PravegaWriterMode> getWriterMode() {
        return this.writerMode;
    }

    public Optional<Long> getTxnLeaseRenewalInterval() {
        return this.txnLeaseRenewalInterval;
    }

    public Optional<Boolean> getWatermark() {
        return this.watermark;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public PravegaConfig getPravegaConfig() {
        return this.pravegaConfig;
    }

    public void setMetrics(Optional<Boolean> metrics) {
        this.metrics = metrics;
    }

    public void setControllerUri(String controllerUri) {
        this.controllerUri = controllerUri;
    }

    public void setDefaultScope(Optional<String> defaultScope) {
        this.defaultScope = defaultScope;
    }

    public void setAuthType(Optional<String> authType) {
        this.authType = authType;
    }

    public void setAuthToken(Optional<String> authToken) {
        this.authToken = authToken;
    }

    public void setValidateHostName(Optional<Boolean> validateHostName) {
        this.validateHostName = validateHostName;
    }

    public void setTrustStore(Optional<String> trustStore) {
        this.trustStore = trustStore;
    }

    public void setUid(Optional<String> uid) {
        this.uid = uid;
    }

    public void setRgScope(Optional<String> rgScope) {
        this.rgScope = rgScope;
    }

    public void setRgName(Optional<String> rgName) {
        this.rgName = rgName;
    }

    public void setRefreshInterval(Optional<Long> refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void setEventReadTimeoutInterval(Optional<Long> eventReadTimeoutInterval) {
        this.eventReadTimeoutInterval = eventReadTimeoutInterval;
    }

    public void setCheckpointInitiateTimeoutInterval(Optional<Long> checkpointInitiateTimeoutInterval) {
        this.checkpointInitiateTimeoutInterval = checkpointInitiateTimeoutInterval;
    }

    public void setReaderStreams(List<StreamWithBoundaries> readerStreams) {
        this.readerStreams = readerStreams;
    }

    public void setAssignerWithTimeWindows(Optional<AssignerWithTimeWindows<Row>> assignerWithTimeWindows) {
        this.assignerWithTimeWindows = assignerWithTimeWindows;
    }

    public void setWriterStream(Stream writerStream) {
        this.writerStream = writerStream;
    }

    public void setWriterMode(Optional<PravegaWriterMode> writerMode) {
        this.writerMode = writerMode;
    }

    public void setTxnLeaseRenewalInterval(Optional<Long> txnLeaseRenewalInterval) {
        this.txnLeaseRenewalInterval = txnLeaseRenewalInterval;
    }

    public void setWatermark(Optional<Boolean> watermark) {
        this.watermark = watermark;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public void setPravegaConfig(PravegaConfig pravegaConfig) {
        this.pravegaConfig = pravegaConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorConfigurations)) {
            return false;
        }
        ConnectorConfigurations other = (ConnectorConfigurations)o;
        Optional<Boolean> this$metrics = this.getMetrics();
        Optional<Boolean> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        String this$controllerUri = this.getControllerUri();
        String other$controllerUri = other.getControllerUri();
        if (this$controllerUri == null ? other$controllerUri != null : !this$controllerUri.equals(other$controllerUri)) {
            return false;
        }
        Optional<String> this$defaultScope = this.getDefaultScope();
        Optional<String> other$defaultScope = other.getDefaultScope();
        if (this$defaultScope == null ? other$defaultScope != null : !((Object)this$defaultScope).equals(other$defaultScope)) {
            return false;
        }
        Optional<String> this$authType = this.getAuthType();
        Optional<String> other$authType = other.getAuthType();
        if (this$authType == null ? other$authType != null : !((Object)this$authType).equals(other$authType)) {
            return false;
        }
        Optional<String> this$authToken = this.getAuthToken();
        Optional<String> other$authToken = other.getAuthToken();
        if (this$authToken == null ? other$authToken != null : !((Object)this$authToken).equals(other$authToken)) {
            return false;
        }
        Optional<Boolean> this$validateHostName = this.getValidateHostName();
        Optional<Boolean> other$validateHostName = other.getValidateHostName();
        if (this$validateHostName == null ? other$validateHostName != null : !((Object)this$validateHostName).equals(other$validateHostName)) {
            return false;
        }
        Optional<String> this$trustStore = this.getTrustStore();
        Optional<String> other$trustStore = other.getTrustStore();
        if (this$trustStore == null ? other$trustStore != null : !((Object)this$trustStore).equals(other$trustStore)) {
            return false;
        }
        Optional<String> this$uid = this.getUid();
        Optional<String> other$uid = other.getUid();
        if (this$uid == null ? other$uid != null : !((Object)this$uid).equals(other$uid)) {
            return false;
        }
        Optional<String> this$rgScope = this.getRgScope();
        Optional<String> other$rgScope = other.getRgScope();
        if (this$rgScope == null ? other$rgScope != null : !((Object)this$rgScope).equals(other$rgScope)) {
            return false;
        }
        Optional<String> this$rgName = this.getRgName();
        Optional<String> other$rgName = other.getRgName();
        if (this$rgName == null ? other$rgName != null : !((Object)this$rgName).equals(other$rgName)) {
            return false;
        }
        Optional<Long> this$refreshInterval = this.getRefreshInterval();
        Optional<Long> other$refreshInterval = other.getRefreshInterval();
        if (this$refreshInterval == null ? other$refreshInterval != null : !((Object)this$refreshInterval).equals(other$refreshInterval)) {
            return false;
        }
        Optional<Long> this$eventReadTimeoutInterval = this.getEventReadTimeoutInterval();
        Optional<Long> other$eventReadTimeoutInterval = other.getEventReadTimeoutInterval();
        if (this$eventReadTimeoutInterval == null ? other$eventReadTimeoutInterval != null : !((Object)this$eventReadTimeoutInterval).equals(other$eventReadTimeoutInterval)) {
            return false;
        }
        Optional<Long> this$checkpointInitiateTimeoutInterval = this.getCheckpointInitiateTimeoutInterval();
        Optional<Long> other$checkpointInitiateTimeoutInterval = other.getCheckpointInitiateTimeoutInterval();
        if (this$checkpointInitiateTimeoutInterval == null ? other$checkpointInitiateTimeoutInterval != null : !((Object)this$checkpointInitiateTimeoutInterval).equals(other$checkpointInitiateTimeoutInterval)) {
            return false;
        }
        List<StreamWithBoundaries> this$readerStreams = this.getReaderStreams();
        List<StreamWithBoundaries> other$readerStreams = other.getReaderStreams();
        if (this$readerStreams == null ? other$readerStreams != null : !((Object)this$readerStreams).equals(other$readerStreams)) {
            return false;
        }
        Optional<AssignerWithTimeWindows<Row>> this$assignerWithTimeWindows = this.getAssignerWithTimeWindows();
        Optional<AssignerWithTimeWindows<Row>> other$assignerWithTimeWindows = other.getAssignerWithTimeWindows();
        if (this$assignerWithTimeWindows == null ? other$assignerWithTimeWindows != null : !((Object)this$assignerWithTimeWindows).equals(other$assignerWithTimeWindows)) {
            return false;
        }
        Stream this$writerStream = this.getWriterStream();
        Stream other$writerStream = other.getWriterStream();
        if (this$writerStream == null ? other$writerStream != null : !this$writerStream.equals(other$writerStream)) {
            return false;
        }
        Optional<PravegaWriterMode> this$writerMode = this.getWriterMode();
        Optional<PravegaWriterMode> other$writerMode = other.getWriterMode();
        if (this$writerMode == null ? other$writerMode != null : !((Object)this$writerMode).equals(other$writerMode)) {
            return false;
        }
        Optional<Long> this$txnLeaseRenewalInterval = this.getTxnLeaseRenewalInterval();
        Optional<Long> other$txnLeaseRenewalInterval = other.getTxnLeaseRenewalInterval();
        if (this$txnLeaseRenewalInterval == null ? other$txnLeaseRenewalInterval != null : !((Object)this$txnLeaseRenewalInterval).equals(other$txnLeaseRenewalInterval)) {
            return false;
        }
        Optional<Boolean> this$watermark = this.getWatermark();
        Optional<Boolean> other$watermark = other.getWatermark();
        if (this$watermark == null ? other$watermark != null : !((Object)this$watermark).equals(other$watermark)) {
            return false;
        }
        String this$routingKey = this.getRoutingKey();
        String other$routingKey = other.getRoutingKey();
        if (this$routingKey == null ? other$routingKey != null : !this$routingKey.equals(other$routingKey)) {
            return false;
        }
        PravegaConfig this$pravegaConfig = this.getPravegaConfig();
        PravegaConfig other$pravegaConfig = other.getPravegaConfig();
        return !(this$pravegaConfig == null ? other$pravegaConfig != null : !((Object)this$pravegaConfig).equals(other$pravegaConfig));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<Boolean> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        String $controllerUri = this.getControllerUri();
        result = result * 59 + ($controllerUri == null ? 43 : $controllerUri.hashCode());
        Optional<String> $defaultScope = this.getDefaultScope();
        result = result * 59 + ($defaultScope == null ? 43 : ((Object)$defaultScope).hashCode());
        Optional<String> $authType = this.getAuthType();
        result = result * 59 + ($authType == null ? 43 : ((Object)$authType).hashCode());
        Optional<String> $authToken = this.getAuthToken();
        result = result * 59 + ($authToken == null ? 43 : ((Object)$authToken).hashCode());
        Optional<Boolean> $validateHostName = this.getValidateHostName();
        result = result * 59 + ($validateHostName == null ? 43 : ((Object)$validateHostName).hashCode());
        Optional<String> $trustStore = this.getTrustStore();
        result = result * 59 + ($trustStore == null ? 43 : ((Object)$trustStore).hashCode());
        Optional<String> $uid = this.getUid();
        result = result * 59 + ($uid == null ? 43 : ((Object)$uid).hashCode());
        Optional<String> $rgScope = this.getRgScope();
        result = result * 59 + ($rgScope == null ? 43 : ((Object)$rgScope).hashCode());
        Optional<String> $rgName = this.getRgName();
        result = result * 59 + ($rgName == null ? 43 : ((Object)$rgName).hashCode());
        Optional<Long> $refreshInterval = this.getRefreshInterval();
        result = result * 59 + ($refreshInterval == null ? 43 : ((Object)$refreshInterval).hashCode());
        Optional<Long> $eventReadTimeoutInterval = this.getEventReadTimeoutInterval();
        result = result * 59 + ($eventReadTimeoutInterval == null ? 43 : ((Object)$eventReadTimeoutInterval).hashCode());
        Optional<Long> $checkpointInitiateTimeoutInterval = this.getCheckpointInitiateTimeoutInterval();
        result = result * 59 + ($checkpointInitiateTimeoutInterval == null ? 43 : ((Object)$checkpointInitiateTimeoutInterval).hashCode());
        List<StreamWithBoundaries> $readerStreams = this.getReaderStreams();
        result = result * 59 + ($readerStreams == null ? 43 : ((Object)$readerStreams).hashCode());
        Optional<AssignerWithTimeWindows<Row>> $assignerWithTimeWindows = this.getAssignerWithTimeWindows();
        result = result * 59 + ($assignerWithTimeWindows == null ? 43 : ((Object)$assignerWithTimeWindows).hashCode());
        Stream $writerStream = this.getWriterStream();
        result = result * 59 + ($writerStream == null ? 43 : $writerStream.hashCode());
        Optional<PravegaWriterMode> $writerMode = this.getWriterMode();
        result = result * 59 + ($writerMode == null ? 43 : ((Object)$writerMode).hashCode());
        Optional<Long> $txnLeaseRenewalInterval = this.getTxnLeaseRenewalInterval();
        result = result * 59 + ($txnLeaseRenewalInterval == null ? 43 : ((Object)$txnLeaseRenewalInterval).hashCode());
        Optional<Boolean> $watermark = this.getWatermark();
        result = result * 59 + ($watermark == null ? 43 : ((Object)$watermark).hashCode());
        String $routingKey = this.getRoutingKey();
        result = result * 59 + ($routingKey == null ? 43 : $routingKey.hashCode());
        PravegaConfig $pravegaConfig = this.getPravegaConfig();
        result = result * 59 + ($pravegaConfig == null ? 43 : ((Object)$pravegaConfig).hashCode());
        return result;
    }

    public String toString() {
        return "ConnectorConfigurations(metrics=" + this.getMetrics() + ", controllerUri=" + this.getControllerUri() + ", defaultScope=" + this.getDefaultScope() + ", authType=" + this.getAuthType() + ", authToken=" + this.getAuthToken() + ", validateHostName=" + this.getValidateHostName() + ", trustStore=" + this.getTrustStore() + ", uid=" + this.getUid() + ", rgScope=" + this.getRgScope() + ", rgName=" + this.getRgName() + ", refreshInterval=" + this.getRefreshInterval() + ", eventReadTimeoutInterval=" + this.getEventReadTimeoutInterval() + ", checkpointInitiateTimeoutInterval=" + this.getCheckpointInitiateTimeoutInterval() + ", readerStreams=" + this.getReaderStreams() + ", assignerWithTimeWindows=" + this.getAssignerWithTimeWindows() + ", writerStream=" + this.getWriterStream() + ", writerMode=" + this.getWriterMode() + ", txnLeaseRenewalInterval=" + this.getTxnLeaseRenewalInterval() + ", watermark=" + this.getWatermark() + ", routingKey=" + this.getRoutingKey() + ", pravegaConfig=" + this.getPravegaConfig() + ")";
    }

    public static final class SimpleCredentials
    implements Credentials {
        private final String authType;
        private final String authToken;

        public SimpleCredentials(String authType, String authToken) {
            this.authType = authType;
            this.authToken = authToken;
        }

        @Override
        public String getAuthenticationType() {
            return this.authType;
        }

        @Override
        public String getAuthenticationToken() {
            return this.authToken;
        }
    }

    public static enum ConfigurationType {
        READER,
        WRITER;

    }
}

