/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink.util;

import io.pravega.connectors.flink.PravegaConfig;
import io.pravega.schemaregistry.client.SchemaRegistryClientConfig;
import io.pravega.schemaregistry.common.CredentialProvider;
import io.pravega.schemaregistry.serializer.shared.credentials.PravegaCredentialProvider;
import org.apache.flink.util.Preconditions;

public class SchemaRegistryUtils {
    public static SchemaRegistryClientConfig getSchemaRegistryClientConfig(PravegaConfig pravegaConfig) {
        Preconditions.checkNotNull((Object)pravegaConfig.getDefaultScope(), (String)"Default Scope should be set for schema registry client");
        Preconditions.checkNotNull((Object)pravegaConfig.getSchemaRegistryUri(), (String)"Schema Registry URI should be set for schema registry client");
        SchemaRegistryClientConfig.SchemaRegistryClientConfigBuilder builder = SchemaRegistryClientConfig.builder().schemaRegistryUri(pravegaConfig.getSchemaRegistryUri());
        if (pravegaConfig.getCredentials() != null) {
            builder.authentication(pravegaConfig.getCredentials().getAuthenticationType(), pravegaConfig.getCredentials().getAuthenticationToken());
        } else {
            builder.authentication((CredentialProvider)new PravegaCredentialProvider(pravegaConfig.getClientConfig()));
        }
        return builder.build();
    }
}

