/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.connectors.flink.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamWithBoundaries
implements Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Stream stream;
    private final StreamCut from;
    private final StreamCut to;

    public static StreamWithBoundaries of(Stream stream, StreamCut from, StreamCut to) {
        Preconditions.checkNotNull((Object)stream, (String)"stream");
        Preconditions.checkNotNull((Object)from, (String)"from");
        Preconditions.checkNotNull((Object)to, (String)"to");
        return new StreamWithBoundaries(stream, from, to);
    }

    public StreamWithBoundaries(Stream stream, StreamCut from, StreamCut to) {
        this.stream = stream;
        this.from = from;
        this.to = to;
    }

    public Stream getStream() {
        return this.stream;
    }

    public StreamCut getFrom() {
        return this.from;
    }

    public StreamCut getTo() {
        return this.to;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamWithBoundaries)) {
            return false;
        }
        StreamWithBoundaries other = (StreamWithBoundaries)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Stream this$stream = this.getStream();
        Stream other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        StreamCut this$from = this.getFrom();
        StreamCut other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        StreamCut this$to = this.getTo();
        StreamCut other$to = other.getTo();
        return !(this$to == null ? other$to != null : !this$to.equals(other$to));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamWithBoundaries;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        StreamCut $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        StreamCut $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        return result;
    }

    public String toString() {
        return "StreamWithBoundaries(stream=" + this.getStream() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

