/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shaded.io.grpc;

import io.pravega.shaded.com.google.common.base.MoreObjects;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.io.grpc.Attributes;
import io.pravega.shaded.io.grpc.CallOptions;
import io.pravega.shaded.io.grpc.ExperimentalApi;
import io.pravega.shaded.io.grpc.Metadata;
import io.pravega.shaded.io.grpc.StreamTracer;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
@ThreadSafe
public abstract class ClientStreamTracer
extends StreamTracer {
    public void outboundHeaders() {
    }

    public void inboundHeaders() {
    }

    public void inboundTrailers(Metadata trailers) {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2861")
    public static final class StreamInfo {
        private final Attributes transportAttrs;
        private final CallOptions callOptions;

        StreamInfo(Attributes transportAttrs, CallOptions callOptions) {
            this.transportAttrs = Preconditions.checkNotNull(transportAttrs, "transportAttrs");
            this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions");
        }

        public Attributes getTransportAttrs() {
            return this.transportAttrs;
        }

        public CallOptions getCallOptions() {
            return this.callOptions;
        }

        public Builder toBuilder() {
            Builder builder = new Builder();
            builder.setTransportAttrs(this.transportAttrs);
            builder.setCallOptions(this.callOptions);
            return builder;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("transportAttrs", this.transportAttrs).add("callOptions", this.callOptions).toString();
        }

        public static final class Builder {
            private Attributes transportAttrs = Attributes.EMPTY;
            private CallOptions callOptions = CallOptions.DEFAULT;

            Builder() {
            }

            public Builder setTransportAttrs(Attributes transportAttrs) {
                this.transportAttrs = Preconditions.checkNotNull(transportAttrs, "transportAttrs cannot be null");
                return this;
            }

            public Builder setCallOptions(CallOptions callOptions) {
                this.callOptions = Preconditions.checkNotNull(callOptions, "callOptions cannot be null");
                return this;
            }

            public StreamInfo build() {
                return new StreamInfo(this.transportAttrs, this.callOptions);
            }
        }
    }

    public static abstract class Factory {
        @Deprecated
        public ClientStreamTracer newClientStreamTracer(CallOptions callOptions, Metadata headers) {
            throw new UnsupportedOperationException("Not implemented");
        }

        public ClientStreamTracer newClientStreamTracer(StreamInfo info, Metadata headers) {
            return this.newClientStreamTracer(info.getCallOptions(), headers);
        }
    }
}

