/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shaded.io.grpc.internal;

import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.com.google.common.base.Stopwatch;
import io.pravega.shaded.io.grpc.InternalServiceProviders;
import io.pravega.shaded.io.grpc.NameResolver;
import io.pravega.shaded.io.grpc.NameResolverProvider;
import io.pravega.shaded.io.grpc.internal.DnsNameResolver;
import io.pravega.shaded.io.grpc.internal.GrpcUtil;
import java.net.URI;

public abstract class BaseDnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";
    @VisibleForTesting
    public static final String ENABLE_GRPCLB_PROPERTY_NAME = "io.pravega.shaded.io.grpc.internal.DnsNameResolverProvider.enable_grpclb";

    protected abstract boolean isSrvEnabled();

    @Override
    public DnsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, args, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader()), this.isSrvEnabled());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }
}

