/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shaded.io.grpc.protobuf;

import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.io.grpc.ExperimentalApi;
import io.pravega.shaded.io.grpc.Metadata;
import io.pravega.shaded.io.grpc.Status;
import io.pravega.shaded.io.grpc.StatusException;
import io.pravega.shaded.io.grpc.StatusRuntimeException;
import io.pravega.shaded.io.grpc.protobuf.lite.ProtoLiteUtils;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4695")
public final class StatusProto {
    private static final Metadata.Key<io.pravega.shaded.com.google.rpc.Status> STATUS_DETAILS_KEY = Metadata.Key.of("grpc-status-details-bin", ProtoLiteUtils.metadataMarshaller(io.pravega.shaded.com.google.rpc.Status.getDefaultInstance()));

    private StatusProto() {
    }

    public static StatusRuntimeException toStatusRuntimeException(io.pravega.shaded.com.google.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto));
    }

    public static StatusRuntimeException toStatusRuntimeException(io.pravega.shaded.com.google.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto, metadata));
    }

    public static StatusException toStatusException(io.pravega.shaded.com.google.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto));
    }

    public static StatusException toStatusException(io.pravega.shaded.com.google.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto, metadata));
    }

    private static Status toStatus(io.pravega.shaded.com.google.rpc.Status statusProto) {
        Status status = Status.fromCodeValue(statusProto.getCode());
        Preconditions.checkArgument(status.getCode().value() == statusProto.getCode(), "invalid status code");
        return status.withDescription(statusProto.getMessage());
    }

    private static Metadata toMetadata(io.pravega.shaded.com.google.rpc.Status statusProto) {
        Metadata metadata = new Metadata();
        metadata.put(STATUS_DETAILS_KEY, statusProto);
        return metadata;
    }

    private static Metadata toMetadata(io.pravega.shaded.com.google.rpc.Status statusProto, Metadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata must not be null");
        metadata.discardAll(STATUS_DETAILS_KEY);
        metadata.put(STATUS_DETAILS_KEY, statusProto);
        return metadata;
    }

    @Nullable
    public static io.pravega.shaded.com.google.rpc.Status fromThrowable(Throwable t) {
        for (Throwable cause = Preconditions.checkNotNull(t, "t"); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                StatusException e = (StatusException)cause;
                return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            StatusRuntimeException e = (StatusRuntimeException)cause;
            return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
        }
        return null;
    }

    @Nullable
    public static io.pravega.shaded.com.google.rpc.Status fromStatusAndTrailers(Status status, Metadata trailers) {
        io.pravega.shaded.com.google.rpc.Status statusProto;
        if (trailers != null && (statusProto = trailers.get(STATUS_DETAILS_KEY)) != null) {
            Preconditions.checkArgument(status.getCode().value() == statusProto.getCode(), "io.pravega.shaded.com.google.rpc.Status code must match gRPC status code");
            return statusProto;
        }
        return null;
    }
}

