/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shaded.io.netty.handler.codec.http.websocketx;

import io.pravega.shaded.io.netty.channel.ChannelHandlerContext;
import io.pravega.shaded.io.netty.handler.codec.MessageToMessageDecoder;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.List;

abstract class WebSocketProtocolHandler
extends MessageToMessageDecoder<WebSocketFrame> {
    private final boolean dropPongFrames;

    WebSocketProtocolHandler() {
        this(true);
    }

    WebSocketProtocolHandler(boolean dropPongFrames) {
        this.dropPongFrames = dropPongFrames;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame frame, List<Object> out) throws Exception {
        if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ctx.channel().writeAndFlush(new PongWebSocketFrame(frame.content()));
            WebSocketProtocolHandler.readIfNeeded(ctx);
            return;
        }
        if (frame instanceof PongWebSocketFrame && this.dropPongFrames) {
            WebSocketProtocolHandler.readIfNeeded(ctx);
            return;
        }
        out.add(frame.retain());
    }

    private static void readIfNeeded(ChannelHandlerContext ctx) {
        if (!ctx.channel().config().isAutoRead()) {
            ctx.read();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.fireExceptionCaught(cause);
        ctx.close();
    }
}

