/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shaded.io.netty.handler.codec.http.websocketx.extensions.compression;

import io.pravega.shaded.io.netty.buffer.ByteBuf;
import io.pravega.shaded.io.netty.buffer.CompositeByteBuf;
import io.pravega.shaded.io.netty.buffer.Unpooled;
import io.pravega.shaded.io.netty.channel.ChannelHandlerContext;
import io.pravega.shaded.io.netty.channel.embedded.EmbeddedChannel;
import io.pravega.shaded.io.netty.handler.codec.CodecException;
import io.pravega.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import io.pravega.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.pravega.shaded.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import io.pravega.shaded.io.netty.util.internal.ObjectUtil;
import java.util.List;

abstract class DeflateDecoder
extends WebSocketExtensionDecoder {
    static final ByteBuf FRAME_TAIL = Unpooled.unreleasableBuffer(Unpooled.wrappedBuffer(new byte[]{0, 0, -1, -1})).asReadOnly();
    private final boolean noContext;
    private final WebSocketExtensionFilter extensionDecoderFilter;
    private EmbeddedChannel decoder;

    DeflateDecoder(boolean noContext, WebSocketExtensionFilter extensionDecoderFilter) {
        this.noContext = noContext;
        this.extensionDecoderFilter = ObjectUtil.checkNotNull(extensionDecoderFilter, "extensionDecoderFilter");
    }

    protected WebSocketExtensionFilter extensionDecoderFilter() {
        return this.extensionDecoderFilter;
    }

    protected abstract boolean appendFrameTail(WebSocketFrame var1);

    protected abstract int newRsv(WebSocketFrame var1);

    @Override
    protected void decode(ChannelHandlerContext ctx, WebSocketFrame msg, List<Object> out) throws Exception {
        WebSocketFrame outMsg;
        ByteBuf partUncompressedContent;
        if (this.decoder == null) {
            if (!(msg instanceof TextWebSocketFrame) && !(msg instanceof BinaryWebSocketFrame)) {
                throw new CodecException("unexpected initial frame type: " + msg.getClass().getName());
            }
            this.decoder = new EmbeddedChannel(ZlibCodecFactory.newZlibDecoder(ZlibWrapper.NONE));
        }
        boolean readable = msg.content().isReadable();
        this.decoder.writeInbound(msg.content().retain());
        if (this.appendFrameTail(msg)) {
            this.decoder.writeInbound(FRAME_TAIL.duplicate());
        }
        CompositeByteBuf compositeUncompressedContent = ctx.alloc().compositeBuffer();
        while ((partUncompressedContent = (ByteBuf)this.decoder.readInbound()) != null) {
            if (!partUncompressedContent.isReadable()) {
                partUncompressedContent.release();
                continue;
            }
            compositeUncompressedContent.addComponent(true, partUncompressedContent);
        }
        if (readable && compositeUncompressedContent.numComponents() <= 0) {
            compositeUncompressedContent.release();
            throw new CodecException("cannot read uncompressed buffer");
        }
        if (msg.isFinalFragment() && this.noContext) {
            this.cleanup();
        }
        if (msg instanceof TextWebSocketFrame) {
            outMsg = new TextWebSocketFrame(msg.isFinalFragment(), this.newRsv(msg), compositeUncompressedContent);
        } else if (msg instanceof BinaryWebSocketFrame) {
            outMsg = new BinaryWebSocketFrame(msg.isFinalFragment(), this.newRsv(msg), compositeUncompressedContent);
        } else if (msg instanceof ContinuationWebSocketFrame) {
            outMsg = new ContinuationWebSocketFrame(msg.isFinalFragment(), this.newRsv(msg), compositeUncompressedContent);
        } else {
            throw new CodecException("unexpected frame type: " + msg.getClass().getName());
        }
        out.add(outMsg);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.handlerRemoved(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.channelInactive(ctx);
    }

    private void cleanup() {
        if (this.decoder != null) {
            if (this.decoder.finish()) {
                ByteBuf buf;
                while ((buf = (ByteBuf)this.decoder.readOutbound()) != null) {
                    buf.release();
                }
            }
            this.decoder = null;
        }
    }
}

