/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.com.google.common.base.Strings;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public final class NameUtils {
    public static final String INTERNAL_NAME_PREFIX = "_";
    public static final String INTERNAL_SCOPE_NAME = "_system";
    public static final String READER_GROUP_STREAM_PREFIX = "_RG";
    public static final int MAX_PREFIX_OR_SUFFIX_SIZE = 5;
    public static final int MAX_NAME_SIZE = 255;
    public static final int MAX_GIVEN_NAME_SIZE = 250;
    static final String TAG_SCOPE = "scope";
    static final String TAG_STREAM = "stream";
    static final String TAG_SEGMENT = "segment";
    static final String TAG_EPOCH = "epoch";
    static final String TAG_DEFAULT = "default";
    static final String TAG_WRITER = "writer";
    private static final String ATTRIBUTE_SUFFIX = "$attributes.index";
    private static final String HEADER_SUFFIX = "$header";
    private static final String OFFSET_SUFFIX = "$offset.";
    private static final String TRANSACTION_DELIMITER = "#transaction.";
    private static final String EPOCH_DELIMITER = ".#epoch.";
    private static final String CHUNK_NAME_FORMAT_WITH_EPOCH_OFFSET = "%s.E-%d-O-%d.%s";
    private static final String METADATA_SEGMENT_NAME_FORMAT = "_system/containers/metadata_%d";
    private static final String STORAGE_METADATA_SEGMENT_NAME_FORMAT = "_system/containers/storage_metadata_%d";
    private static final String SYSJOURNAL_NAME_FORMAT = "_system/containers/_sysjournal.epoch%d.container%d.file%d";
    private static final int TRANSACTION_PART_LENGTH = 16;
    private static final int TRANSACTION_ID_LENGTH = 32;
    private static final String FULL_HEX_FORMAT = "%016x";
    private static final String TABLES = "_tables";
    private static final String KVTABLE_SUFFIX = "_kvtable";
    private static final String MARK_PREFIX = "_MARK";

    public static String getTransactionNameFromId(String parentStreamSegmentName, UUID transactionId) {
        StringBuilder result = new StringBuilder();
        result.append(parentStreamSegmentName);
        result.append(TRANSACTION_DELIMITER);
        result.append(String.format(FULL_HEX_FORMAT, transactionId.getMostSignificantBits()));
        result.append(String.format(FULL_HEX_FORMAT, transactionId.getLeastSignificantBits()));
        return result.toString();
    }

    public static String getParentStreamSegmentName(String transactionName) {
        int endOfStreamNamePos = transactionName.lastIndexOf(TRANSACTION_DELIMITER);
        if (endOfStreamNamePos < 0 || endOfStreamNamePos + TRANSACTION_DELIMITER.length() + 32 > transactionName.length()) {
            return null;
        }
        return transactionName.substring(0, endOfStreamNamePos);
    }

    public static boolean isTransactionSegment(String streamSegmentName) {
        int endOfStreamNamePos = streamSegmentName.lastIndexOf(TRANSACTION_DELIMITER);
        return endOfStreamNamePos >= 0 && endOfStreamNamePos + TRANSACTION_DELIMITER.length() + 32 <= streamSegmentName.length();
    }

    public static String extractPrimaryStreamSegmentName(String streamSegmentName) {
        if (NameUtils.isTransactionSegment(streamSegmentName)) {
            return NameUtils.extractPrimaryStreamSegmentName(NameUtils.getParentStreamSegmentName(streamSegmentName));
        }
        int endOfStreamNamePos = streamSegmentName.lastIndexOf(EPOCH_DELIMITER);
        if (endOfStreamNamePos < 0) {
            return streamSegmentName;
        }
        return streamSegmentName.substring(0, endOfStreamNamePos);
    }

    public static boolean isAttributeSegment(String segmentName) {
        return segmentName.endsWith(ATTRIBUTE_SUFFIX);
    }

    public static String getAttributeSegmentName(String segmentName) {
        Preconditions.checkArgument(!NameUtils.isAttributeSegment(segmentName), "segmentName is already an attribute segment name");
        return segmentName + ATTRIBUTE_SUFFIX;
    }

    public static String getHeaderSegmentName(String segmentName) {
        Preconditions.checkArgument(!segmentName.endsWith(HEADER_SUFFIX), "segmentName is already a segment header name");
        return segmentName + HEADER_SUFFIX;
    }

    public static boolean isHeaderSegment(String segmentName) {
        return segmentName.endsWith(HEADER_SUFFIX);
    }

    public static String getSegmentNameFromHeader(String headerSegmentName) {
        Preconditions.checkArgument(headerSegmentName.endsWith(HEADER_SUFFIX));
        return headerSegmentName.substring(0, headerSegmentName.length() - HEADER_SUFFIX.length());
    }

    public static String getSegmentChunkName(String segmentName, long offset) {
        Preconditions.checkArgument(!segmentName.contains(OFFSET_SUFFIX), "segmentName is already a SegmentChunk name");
        return segmentName + OFFSET_SUFFIX + Long.toString(offset);
    }

    public static String getSegmentChunkName(String segmentName, long epoch, long offset) {
        return String.format(CHUNK_NAME_FORMAT_WITH_EPOCH_OFFSET, segmentName, epoch, offset, UUID.randomUUID());
    }

    public static String getMetadataSegmentName(int containerId) {
        Preconditions.checkArgument(containerId >= 0, "containerId must be a non-negative number.");
        return String.format(METADATA_SEGMENT_NAME_FORMAT, containerId);
    }

    public static String getStorageMetadataSegmentName(int containerId) {
        Preconditions.checkArgument(containerId >= 0, "containerId must be a non-negative number.");
        return String.format(STORAGE_METADATA_SEGMENT_NAME_FORMAT, containerId);
    }

    public static String getSystemJournalFileName(int containerId, long epoch, long currentFileIndex) {
        return String.format(SYSJOURNAL_NAME_FORMAT, epoch, containerId, currentFileIndex);
    }

    public static long computeSegmentId(int segmentNumber, int epoch) {
        Preconditions.checkArgument(segmentNumber >= 0);
        Preconditions.checkArgument(epoch >= 0);
        return (long)epoch << 32 | (long)segmentNumber & 0xFFFFFFFFL;
    }

    public static int getSegmentNumber(long segmentId) {
        return (int)segmentId;
    }

    public static int getEpoch(long segmentId) {
        return (int)(segmentId >> 32);
    }

    public static int getEpoch(UUID txnId) {
        return (int)(txnId.getMostSignificantBits() >> 32);
    }

    public static String getScopedStreamName(String scope, String streamName) {
        return NameUtils.getScopedStreamNameInternal(scope, streamName).toString();
    }

    public static String getScopedKeyValueTableName(String scope, String streamName) {
        return NameUtils.getScopedStreamNameInternal(scope, streamName).toString();
    }

    public static String getScopedReaderGroupName(String scope, String rgName) {
        return NameUtils.getScopedStreamNameInternal(scope, rgName).toString();
    }

    public static String getQualifiedTableSegmentName(String scope, String kvTableName, long segmentId) {
        int segmentNumber = NameUtils.getSegmentNumber(segmentId);
        int epoch = NameUtils.getEpoch(segmentId);
        StringBuffer sb = NameUtils.getScopedStreamNameInternal(scope, kvTableName + KVTABLE_SUFFIX);
        sb.append('/');
        sb.append(segmentNumber);
        sb.append(EPOCH_DELIMITER);
        sb.append(epoch);
        return sb.toString();
    }

    public static List<String> extractScopedNameTokens(String scopedName) {
        String[] tokens = scopedName.split("/");
        Preconditions.checkArgument(tokens.length == 2, "Unexpected format for '%s'. Expected format '<scope-name>/<name>'.", (Object)scopedName);
        return Arrays.asList(tokens);
    }

    public static String getQualifiedStreamSegmentName(String scope, String streamName, long segmentId) {
        int segmentNumber = NameUtils.getSegmentNumber(segmentId);
        int epoch = NameUtils.getEpoch(segmentId);
        StringBuffer sb = NameUtils.getScopedStreamNameInternal(scope, streamName);
        sb.append('/');
        sb.append(segmentNumber);
        sb.append(EPOCH_DELIMITER);
        sb.append(epoch);
        return sb.toString();
    }

    public static List<String> extractSegmentTokens(String qualifiedName) {
        long segmentId;
        int segmentIdIndex;
        Preconditions.checkNotNull(qualifiedName);
        String originalSegmentName = NameUtils.isTransactionSegment(qualifiedName) ? NameUtils.getParentStreamSegmentName(qualifiedName) : qualifiedName;
        LinkedList<String> retVal = new LinkedList<String>();
        String[] tokens = originalSegmentName.split("/");
        int n = segmentIdIndex = tokens.length == 2 ? 1 : 2;
        if (tokens[segmentIdIndex].contains(EPOCH_DELIMITER)) {
            String[] segmentIdTokens = tokens[segmentIdIndex].split(EPOCH_DELIMITER);
            segmentId = NameUtils.computeSegmentId(Integer.parseInt(segmentIdTokens[0]), Integer.parseInt(segmentIdTokens[1]));
        } else {
            segmentId = NameUtils.computeSegmentId(Integer.parseInt(tokens[segmentIdIndex]), 0);
        }
        retVal.add(tokens[0]);
        if (tokens.length == 3) {
            retVal.add(tokens[1]);
        }
        retVal.add(Long.toString(segmentId));
        return retVal;
    }

    private static StringBuffer getScopedStreamNameInternal(String scope, String streamName) {
        StringBuffer sb = new StringBuffer();
        if (!Strings.isNullOrEmpty(scope)) {
            sb.append(scope);
            sb.append('/');
        }
        sb.append(streamName);
        return sb;
    }

    public static String getQualifiedTableName(String scope, String ... tokens) {
        Preconditions.checkArgument(tokens != null && tokens.length > 0);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s/%s", scope, TABLES));
        for (String token : tokens) {
            sb.append('/');
            sb.append(token);
        }
        return sb.toString();
    }

    public static List<String> extractTableSegmentTokens(String qualifiedName) {
        Preconditions.checkNotNull(qualifiedName);
        LinkedList<String> retVal = new LinkedList<String>();
        String[] tokens = qualifiedName.split("/");
        Preconditions.checkArgument(tokens.length > 2);
        Preconditions.checkArgument(tokens[1].equals(TABLES));
        retVal.add(tokens[0]);
        for (int i = 2; i < tokens.length; ++i) {
            retVal.add(tokens[i]);
        }
        return retVal;
    }

    public static boolean isTableSegment(String qualifiedName) {
        Preconditions.checkNotNull(qualifiedName);
        String[] tokens = qualifiedName.split("/");
        Preconditions.checkArgument(tokens.length > 2);
        return tokens[1].equals(TABLES);
    }

    public static String[] segmentTags(String qualifiedSegmentName) {
        Preconditions.checkNotNull(qualifiedSegmentName);
        String[] tags = new String[]{TAG_SCOPE, null, TAG_STREAM, null, TAG_SEGMENT, null, TAG_EPOCH, null};
        return NameUtils.updateSegmentTags(qualifiedSegmentName, tags);
    }

    public static String[] segmentTags(String qualifiedSegmentName, String writerId) {
        Preconditions.checkNotNull(qualifiedSegmentName);
        Exceptions.checkNotNullOrEmpty(writerId, "writerId");
        String[] tags = new String[]{TAG_SCOPE, null, TAG_STREAM, null, TAG_SEGMENT, null, TAG_EPOCH, null, TAG_WRITER, null};
        NameUtils.updateSegmentTags(qualifiedSegmentName, tags);
        tags[9] = writerId;
        return tags;
    }

    private static String[] updateSegmentTags(String qualifiedSegmentName, String[] tags) {
        int segmentIdIndex;
        String segmentBaseName = NameUtils.getSegmentBaseName(qualifiedSegmentName);
        String[] tokens = segmentBaseName.split("/");
        int n = tokens.length == 1 ? 0 : (segmentIdIndex = tokens.length == 2 ? 1 : 2);
        if (tokens[segmentIdIndex].contains(EPOCH_DELIMITER)) {
            String[] segmentIdTokens = tokens[segmentIdIndex].split(EPOCH_DELIMITER);
            tags[5] = segmentIdTokens[0];
            tags[7] = segmentIdTokens[1];
        } else {
            tags[5] = tokens[segmentIdIndex];
            tags[7] = "0";
        }
        if (tokens.length == 3) {
            tags[1] = tokens[0];
            tags[3] = tokens[1];
        } else if (tokens.length == 1) {
            tags[1] = TAG_DEFAULT;
            tags[3] = TAG_DEFAULT;
        } else {
            tags[1] = TAG_DEFAULT;
            tags[3] = tokens[0];
        }
        return tags;
    }

    public static String[] writerTags(String writerId) {
        Exceptions.checkNotNullOrEmpty(writerId, "writerId");
        return new String[]{TAG_WRITER, writerId};
    }

    private static String getSegmentBaseName(String segmentQualifiedName) {
        String segmentBaseName = NameUtils.getParentStreamSegmentName(segmentQualifiedName);
        return segmentBaseName == null ? segmentQualifiedName : segmentBaseName;
    }

    public static String getInternalNameForStream(String streamName) {
        return INTERNAL_NAME_PREFIX + streamName;
    }

    public static String getStreamForReaderGroup(String groupNameName) {
        return READER_GROUP_STREAM_PREFIX + groupNameName;
    }

    public static String validateUserStreamName(String name) {
        Preconditions.checkNotNull(name);
        Preconditions.checkArgument(name.length() <= 250, "Name cannot exceed %s characters", 250);
        Preconditions.checkArgument(name.matches("[\\p{Alnum}\\.\\-]+"), "Name must be a-z, 0-9, ., -.");
        return name;
    }

    public static String validateUserKeyValueTableName(String name) {
        return NameUtils.validateUserStreamName(name);
    }

    public static String validateStreamName(String name) {
        Preconditions.checkNotNull(name);
        String matcher = "[_]?[\\p{Alnum}\\.\\-]+";
        Preconditions.checkArgument(name.length() <= 255, "Name cannot exceed %s characters", 255);
        Preconditions.checkArgument(name.matches("[_]?[\\p{Alnum}\\.\\-]+"), "Name must be [_]?[\\p{Alnum}\\.\\-]+");
        return name;
    }

    public static String validateUserScopeName(String name) {
        Preconditions.checkNotNull(name);
        Preconditions.checkArgument(name.length() <= 255, "Name cannot exceed %s characters", 255);
        Preconditions.checkArgument(name.matches("[\\p{Alnum}\\.\\-]+"), "Name must be a-z, 0-9, ., -.");
        return name;
    }

    public static String validateScopeName(String name) {
        return NameUtils.validateStreamName(name);
    }

    public static String validateReaderGroupName(String name) {
        return NameUtils.validateUserStreamName(name);
    }

    public static String validateReaderId(String readerId) {
        return NameUtils.validateUserStreamName(readerId);
    }

    public static String validateWriterId(String writerId) {
        return NameUtils.validateUserStreamName(writerId);
    }

    public static String getMarkStreamForStream(String stream) {
        StringBuffer sb = new StringBuffer();
        sb.append(MARK_PREFIX);
        sb.append(stream);
        return sb.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static String getMARK_PREFIX() {
        return MARK_PREFIX;
    }
}

