/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.StreamRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class CommitEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String stream;
    private final int epoch;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.stream);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((StreamRequestProcessor)processor).processCommitTxnRequest(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static CommitEventBuilder builder() {
        return new CommitEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStream() {
        return this.stream;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getEpoch() {
        return this.epoch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommitEvent)) {
            return false;
        }
        CommitEvent other = (CommitEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        return this.getEpoch() == other.getEpoch();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommitEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        result = result * 59 + this.getEpoch();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "CommitEvent(scope=" + this.getScope() + ", stream=" + this.getStream() + ", epoch=" + this.getEpoch() + ")";
    }

    @ConstructorProperties(value={"scope", "stream", "epoch"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CommitEvent(String scope, String stream, int epoch) {
        this.scope = scope;
        this.stream = stream;
        this.epoch = epoch;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<CommitEvent, CommitEventBuilder> {
        @Override
        protected CommitEventBuilder newBuilder() {
            return CommitEvent.builder();
        }

        @Override
        protected byte getWriteVersion() {
            return 0;
        }

        @Override
        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(CommitEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.stream);
            target.writeCompactInt(e.epoch);
        }

        private void read00(RevisionDataInput source, CommitEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.stream(source.readUTF());
            b.epoch(source.readCompactInt());
        }
    }

    private static class CommitEventBuilder
    implements ObjectBuilder<CommitEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String stream;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private int epoch;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        CommitEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CommitEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CommitEventBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CommitEventBuilder epoch(int epoch) {
            this.epoch = epoch;
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CommitEvent build() {
            return new CommitEvent(this.scope, this.stream, this.epoch);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "CommitEvent.CommitEventBuilder(scope=" + this.scope + ", stream=" + this.stream + ", epoch=" + this.epoch + ")";
        }
    }
}

