/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.shared.controller.event.ControllerEvent;
import io.pravega.shared.controller.event.RequestProcessor;
import io.pravega.shared.controller.event.StreamRequestProcessor;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class DeleteReaderGroupEvent
implements ControllerEvent {
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final String rgName;
    private final long requestId;
    private UUID readerGroupId;

    @Override
    public String getKey() {
        return String.format("%s/%s", this.scope, this.rgName);
    }

    @Override
    public CompletableFuture<Void> process(RequestProcessor processor) {
        return ((StreamRequestProcessor)processor).processDeleteReaderGroup(this);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DeleteReaderGroupEventBuilder builder() {
        return new DeleteReaderGroupEventBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getScope() {
        return this.scope;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getRgName() {
        return this.rgName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRequestId() {
        return this.requestId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID getReaderGroupId() {
        return this.readerGroupId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setReaderGroupId(UUID readerGroupId) {
        this.readerGroupId = readerGroupId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteReaderGroupEvent)) {
            return false;
        }
        DeleteReaderGroupEvent other = (DeleteReaderGroupEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$rgName = this.getRgName();
        String other$rgName = other.getRgName();
        if (this$rgName == null ? other$rgName != null : !this$rgName.equals(other$rgName)) {
            return false;
        }
        if (this.getRequestId() != other.getRequestId()) {
            return false;
        }
        UUID this$readerGroupId = this.getReaderGroupId();
        UUID other$readerGroupId = other.getReaderGroupId();
        return !(this$readerGroupId == null ? other$readerGroupId != null : !((Object)this$readerGroupId).equals(other$readerGroupId));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DeleteReaderGroupEvent;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $rgName = this.getRgName();
        result = result * 59 + ($rgName == null ? 43 : $rgName.hashCode());
        long $requestId = this.getRequestId();
        result = result * 59 + (int)($requestId >>> 32 ^ $requestId);
        UUID $readerGroupId = this.getReaderGroupId();
        result = result * 59 + ($readerGroupId == null ? 43 : ((Object)$readerGroupId).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DeleteReaderGroupEvent(scope=" + this.getScope() + ", rgName=" + this.getRgName() + ", requestId=" + this.getRequestId() + ", readerGroupId=" + this.getReaderGroupId() + ")";
    }

    @ConstructorProperties(value={"scope", "rgName", "requestId", "readerGroupId"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DeleteReaderGroupEvent(String scope, String rgName, long requestId, UUID readerGroupId) {
        this.scope = scope;
        this.rgName = rgName;
        this.requestId = requestId;
        this.readerGroupId = readerGroupId;
    }

    public static class Serializer
    extends VersionedSerializer.WithBuilder<DeleteReaderGroupEvent, DeleteReaderGroupEventBuilder> {
        @Override
        protected DeleteReaderGroupEventBuilder newBuilder() {
            return DeleteReaderGroupEvent.builder();
        }

        @Override
        protected byte getWriteVersion() {
            return 0;
        }

        @Override
        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void write00(DeleteReaderGroupEvent e, RevisionDataOutput target) throws IOException {
            target.writeUTF(e.scope);
            target.writeUTF(e.rgName);
            target.writeLong(e.requestId);
            target.writeUUID(e.readerGroupId);
        }

        private void read00(RevisionDataInput source, DeleteReaderGroupEventBuilder b) throws IOException {
            b.scope(source.readUTF());
            b.rgName(source.readUTF());
            b.requestId(source.readLong());
            b.readerGroupId(source.readUUID());
        }
    }

    private static class DeleteReaderGroupEventBuilder
    implements ObjectBuilder<DeleteReaderGroupEvent> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String scope;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String rgName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long requestId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private UUID readerGroupId;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DeleteReaderGroupEventBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteReaderGroupEventBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteReaderGroupEventBuilder rgName(String rgName) {
            this.rgName = rgName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteReaderGroupEventBuilder requestId(long requestId) {
            this.requestId = requestId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteReaderGroupEventBuilder readerGroupId(UUID readerGroupId) {
            this.readerGroupId = readerGroupId;
            return this;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DeleteReaderGroupEvent build() {
            return new DeleteReaderGroupEvent(this.scope, this.rgName, this.requestId, this.readerGroupId);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "DeleteReaderGroupEvent.DeleteReaderGroupEventBuilder(scope=" + this.scope + ", rgName=" + this.rgName + ", requestId=" + this.requestId + ", readerGroupId=" + this.readerGroupId + ")";
        }
    }
}

